/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.relations;

import com.ohell.data.OhellGame;
import com.ohell.data.Player;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import static javax.persistence.GenerationType.IDENTITY;

/**
 *
 * @author vasko
 */
@Entity
@Table(name = "game_player_rel", catalog = "ohell_schema")
public class GamePlayerRel implements java.io.Serializable {

    private Integer id;
    private OhellGame game;
    private Player player;
    private int seatIndex;   

    public GamePlayerRel() {
    }

    
    public GamePlayerRel(OhellGame game, Player player) {
        this.game = game;
        this.player = player;
    }

    @Id
    @GeneratedValue(strategy = IDENTITY)
    @Column(name = "id", unique = true, nullable = false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "game_id", nullable = false)
    public OhellGame getGame() {
        return this.game;
    }

    public void setGame(OhellGame game) {
        this.game = game;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "player_id", nullable = false)
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    @Column(name="seatIndex")
    public int getSeatIndex () {
        return seatIndex;
    }

    public void setSeatIndex (int val) {
        this.seatIndex = val;
    }
}
