/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.client.data;

import com.ohell.data.Card;
import com.ohell.rules.OhellRulesManager;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author vasko
 */
public class Hand {

    private List<Card> cards;

    public Hand() {
        cards = new ArrayList<Card>();
    }

    /**
     * Cards in the list are added in the order they were played - the first added card is the first one played etc.
     * @return List of the Cards played in this hand.
     */
    public List<Card> getCards() {
        return cards;
    }

    public void addPlayedCard(Card c){
        cards.add(c);
    }

    public Card getFirstPlayedCard(){
        return cards.get(0);
    }

    public boolean isHandOver(){
        return OhellRulesManager.isCurrentHandOver(cards.size());
    }
}
