/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.data;

import com.ohell.data.Card;
import com.ohell.rules.OhellRulesManager;
import java.util.HashMap;

/**
 * Important - roundNumber IS NOT ZEROBASED - it starts from 1 so that it is equal to the number of cards in eachPlayer for this round
 * @author vasko
 */
public class Round {
    private Card trump;

    private static final int PLAYERS_COUNT = 4;
    private int roundNumber;
    private HashMap<Integer, Integer> announcesMap;
    private HashMap<Integer, Integer> takenHandsMap;

    public Card getTrump() {
        return trump;
    }
    
    /**
     * Important - roundNumber IS NOT ZEROBASED - it starts from 1 so that it is equal to the number of cards in eachPlayer for this round
     */
    public int getRoundNumber() {
        return roundNumber;
    }

    /**
     * Important - roundNumber IS NOT ZEROBASED - it starts from 1 so that it is equal to the number of cards in eachPlayer for this round
     */
    public void setRoundNumber(int roundNumber) {
        this.roundNumber = roundNumber;
    }

    public Round(int roundNumber,Card trump) {
        this.roundNumber = roundNumber;
        this.trump = trump;

        announcesMap = new HashMap<Integer, Integer>();

        takenHandsMap = new HashMap<Integer, Integer>();
        takenHandsMap.put(0, 0);
        takenHandsMap.put(1, 0);
        takenHandsMap.put(2, 0);
        takenHandsMap.put(3, 0);
    }

    /**
     * Sets the announce of a player
     * @param seatIndex - the seatIndex of the player whose announce is to be set
     * @param hands = the number of announced hands
     */
    public void setAnnounce(int seatIndex, int hands) {
        announcesMap.put(seatIndex, hands);
    }

    /**
     *
     * @param seatIndex - the seatIndex of the player whose announce is ot be returned
     * @return the number of hands announced by a player or NULL if player hasn't made any
     */
    public Integer getAnnounce(int seatIndex) {
        return announcesMap.get(seatIndex);
    }

    /**
     * Increment the number of player's taken hands with one
     * @param seatIndex - the seatIndex of the player whose taken hands are to be incremented
     */
    public void incrementTakenHands(int seatIndex) {
        System.out.println("Increenting hands of seatIndex: "+seatIndex);
        Integer currentTakenHands = getTakenHands(seatIndex);
        if(currentTakenHands == null){
            currentTakenHands = 0;
        }
        takenHandsMap.put(seatIndex, currentTakenHands + 1);
    }

    /**
     *
     * @param seatIndex - the seatIndex of the player whose currently taken hands are to be returned
     * @return number of hands currently taken by the specified player
     */
    public Integer getTakenHands(int seatIndex) {
        Object result = takenHandsMap.get(seatIndex);
        if(result == null){
            return 0;
        }else{
            return (Integer)result;
        }
    }

    /**
     *
     * @return true if all players have made announce, false otherwise
     */
    public boolean isAnnouncesComeplete() {
        return OhellRulesManager.isRoundAnnouncesMade(announcesMap.size());
    }

    /**
     *
     * @return true if all players' cards are played for this round
     */
    public boolean isRoundComplete() {
        return OhellRulesManager.isCurrentRoundOver(roundNumber, allCurrentlyTakenHands());
    }

    private int allCurrentlyTakenHands() {
        int first = getTakenHands(0) == null ? 0 : getTakenHands(0);
        int second = getTakenHands(1) == null ? 0 : getTakenHands(1);
        int third = getTakenHands(2) == null ? 0 : getTakenHands(2);
        int fourth = getTakenHands(3) == null ? 0 : getTakenHands(3);
        return first + second + third + fourth;
    }
}
