/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.state;

import com.ohell.client.data.GameBean;
import com.ohell.client.ui.OhellGameClient;
import com.ohell.communication.clienttoserver.RoundOverObject;
import com.ohell.communication.common.AnnounceObject;
import com.ohell.communication.common.ChatObject;
import com.ohell.communication.common.PlayedMoveObject;
import com.ohell.communication.common.PlayerObject;
import com.ohell.communication.servertoclient.GameStartingObject;
import com.ohell.communication.servertoclient.InitNextRoundObject;
import com.ohell.data.Announce;
import com.ohell.data.Player;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 *
 * @author User
 */
public class GameState extends ClientState {

    private OhellGameClient mediator;

    public GameState(OhellGameClient mediator) {
        this.mediator = mediator;
    }

    @Override
    public void processCommunicationObject(Object o) {
        if (o instanceof ChatObject) {
            ChatObject co = (ChatObject) o;
            mediator.getGamePanel().displayMessage(co.getPlayer().getNickname() + ": " + co.getMessage());
        } else if (o instanceof PlayerObject) {
            Player tmpPlayer = ((PlayerObject) o).getPlayer();
            mediator.getGamePanel().addPlayerInGame(tmpPlayer);
            mediator.getGamePanel().displayMessage(tmpPlayer.getNickname() + " just entered the table");
        } else if (o instanceof GameStartingObject) {
            GameStartingObject gso = ((GameStartingObject) o);

            int seatIndexOfCurrentPlayer = getCurrentSeatIndex(gso);
            mediator.getGamePanel().setSeatIndexOfPlayer(seatIndexOfCurrentPlayer);
            initGameModelWithSeatIndexes(gso);

            List<Announce> list = gso.getAnnounces();
            HashMap<Integer, Announce> announceMap = new HashMap<Integer, Announce>();
            for (Announce announce : list) {
                announceMap.put(announce.getCode(), announce);
//                mediator.getGamePanel().displayMessage(announce.toString());
            }
            mediator.getGamePanel().getGameModel().setAnnounces(announceMap);
        } else if (o instanceof InitNextRoundObject) {
            InitNextRoundObject inro = (InitNextRoundObject) o;
            mediator.getGamePanel().startRound(inro.getCards(), inro.getTrump(), inro.getRoundNumber());
            mediator.repaint();
        } else if (o instanceof AnnounceObject) {
            AnnounceObject ao = (AnnounceObject) o;
            GameBean gameModel = mediator.getGamePanel().getGameModel();
            gameModel.updateAnnounce(ao.getSeatIndex(), ao.getAnnounce());

            //now why does GameState need to know anything about UI components ordering?
            mediator.getGamePanel().getBoard().updateBoardWithAnnounceMade(ao.getSeatIndex(), ao.getAnnounce());
            Graphics g = mediator.getGamePanel().getAnnouncePanel().getGraphics();
            mediator.getGamePanel().getAnnouncePanel().paint(g);
        } else if (o instanceof PlayedMoveObject) {
            PlayedMoveObject pmo = (PlayedMoveObject) o;

            //update gameModel
            GameBean gameModel = mediator.getGamePanel().getGameModel();
            if (gameModel != null) {
                System.out.println("UpdateWithPlayedCard when receiving from other player - seatIndex=" + pmo.getSeatIndex());
                gameModel.updateWithPlayedCard(pmo.getSeatIndex(), pmo.getPlayedCard());
                mediator.getGamePanel().getScoreTable().repaint();
                
                //patch bad gameModel design with updating CardsPanel - removing a card from the UI
                //TODO : all model-related properties should be in GameBean and all UI properties should be bound to that GameBean model object.When it is updated, the UI is automagically updated.
                //(And there is no nedd for this modul to know the structure of all Panels etc.)
                //The real problem here, is that the makeMove() method has no way to know whether or not the GameBean, on which it depands, is updated or not.So it is a true spaghetti code.                
                mediator.getGamePanel().getBoard().updateBoardWithCardMove(pmo.getPlayedCard(),mediator);
            }
        }
    }

    private int getCurrentSeatIndex(GameStartingObject gso) {
        long currentPlayerId = mediator.getPlayer().getId();
        Map<Integer, Long> map = gso.getSeatIndexMap();
        Iterator<Integer> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            int tempSeatIndex = iter.next();
            long tempId = map.get(tempSeatIndex);
            if (tempId == currentPlayerId) {
                return tempSeatIndex;
            }
        }
        //this should never be reached
        return -1;
    }

    private void initGameModelWithSeatIndexes(GameStartingObject gso) {
        Map<Integer, Player> playersMap = new HashMap<Integer, Player>();
        List<Player> players = mediator.getGamePanel().getPlayers();
        Map<Integer, Long> playersIdMap = gso.getSeatIndexMap();

        Iterator<Integer> seatIndexIterator = playersIdMap.keySet().iterator();
        while (seatIndexIterator.hasNext()) {
            int tempSeatIndex = seatIndexIterator.next();
            long playerId = playersIdMap.get(tempSeatIndex);
            Player tempPlayer = getPlayerById(players, playerId);
            playersMap.put(tempSeatIndex, tempPlayer);

            //for test issues
            mediator.getGamePanel().displayMessage(tempPlayer.getNickname() + " is placed at seat: " + tempSeatIndex);
        }
        mediator.getGamePanel().initGameStart(playersMap);
    }

    private Player getPlayerById(List<Player> list, long id) {
        for (Player player : list) {
            if (player.getId().longValue() == id) {
                return player;
            }
        }
        return null;
    }
}
