/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.state;

import com.ohell.client.ui.OhellGameClient;
import com.ohell.client.ui.custom.components.TablesJPanel;
import com.ohell.communication.common.PlayerObject;
import com.ohell.communication.servertoclient.FailLoginObject;
import com.ohell.communication.servertoclient.TablesObject;
import com.ohell.data.GameTable;
import java.util.List;
import javax.swing.SwingUtilities;

/**
 *
 * @author User
 */
public class LoginState extends ClientState {

    private OhellGameClient mediator;

    public LoginState(OhellGameClient mediator) {
        this.mediator = mediator;
    }

    //processign messages recieved by client
    @Override
    public void processCommunicationObject(Object o) {
        if (o instanceof FailLoginObject) {
            FailLoginObject flo = (FailLoginObject) o;
            displayMessage(flo.getErrorMessage());
        } else if (o instanceof TablesObject) {
            //this object is sent by server after successful authentication
            TablesObject tableObject = (TablesObject) o;
            List<GameTable> tables = tableObject.getTables();
            TablesJPanel tmpPanel = new TablesJPanel(tables, mediator);
            mediator.setTablesPanel(tmpPanel);
            mediator.remove(mediator.getLoginPanel());
            mediator.add(tmpPanel);
            mediator.setSize(tmpPanel.getWidth(), tmpPanel.getHeight());
            mediator.setState(new ChooseTableState(mediator));
        } else if (o instanceof PlayerObject) {
            mediator.setPlayer(((PlayerObject) o).getPlayer());
            mediator.setTitle(((PlayerObject) o).getPlayer().getNickname());
        } else {
            displayMessage("Unprocessable object");
        }
    }

    //displaying message in displayArea using event-dispatch thread
    private void displayMessage(final String message) {
        SwingUtilities.invokeLater(
                new Runnable() {

                    public void run() {
                        mediator.getLoginPanel().displayMessage(message);
                    }//end run method
                }//end inner anonymous class
                );//end call to invokeLater
    }//end method displayMessage
}