package com.ohell.client.ui;


import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Formatter;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/**
 * This is the client JFrame class. It is also Runnable because communication logic must be separated from AWT UI Thread.
 * That is why it is run in separate tread.
 * @author Vasko
 */
public class DeprecatedOhellGameClient extends JFrame implements Runnable{

    private JTextField enterField; // enters information from user
    
    private JTextArea displayArea;
    private Socket connection; //used to connect to server
    private Scanner input; //input from server
    private Formatter output; //output to server
    

    /**
     * This is very important - must be managed localy for the client application according to communication with server
     */
    private boolean myTurn = true;

    private String serverHostName;//server's host name
    private int serverPort;//server's port

    //constructor initializing GUI 
    public DeprecatedOhellGameClient(String host,int port) {
        serverHostName = host;//set server name
        serverPort = port;

        enterField = new JTextField(); // create enterField        
        enterField.addActionListener(
                new ActionListener() {
                    // send message to server

                    public void actionPerformed(ActionEvent event) {
                        String msg = event.getActionCommand();
                        sendData(msg);
                        enterField.setText("");
                        displayMessage("Me:"+msg+"\n");
                    } // end method actionPerformed
                } // end anonymous inner class
                ); // end call to addActionListener

        add(enterField, BorderLayout.NORTH);


        displayArea = new JTextArea(10,20);
        displayArea.setEditable(false);
        add(new JScrollPane(displayArea),BorderLayout.SOUTH);
        
        setSize(300,250);
        setVisible(true);  
        
        startClient();
    }//end constructor
    
    //start the Client thread
    public void startClient(){
        
        try{//connect to server and get streams 
            connection = new Socket(InetAddress.getByName(serverHostName),serverPort);
            input = new Scanner(connection.getInputStream());
            output = new Formatter(connection.getOutputStream());          
        }catch(IOException ioe){
            ioe.printStackTrace();
        }//end try catch
        
        //create and start thread for this client        
        ExecutorService es = Executors.newFixedThreadPool(1);
        es.execute(this);//executes current client
    }//end method startClient
    
    public void run() {            
            while(true){
                if(input.hasNextLine())
                    processMessage(input.nextLine());
            }//end while
    }//end run method
    
    //processign messages recieved by client
    private void processMessage(String message){
            displayMessage(message + "\n");//any other message from server is not related to current game state        
    }//end processMessage method


    //displaying message in displayArea using event-dispatch thread
    private void displayMessage(final String message){
        SwingUtilities.invokeLater(
            new Runnable() {
                public void run() {
                    displayArea.append(message);

                    //always scroll down
                    int endIndex = displayArea.getDocument().getLength() - 1;
                    displayArea.setCaretPosition(endIndex);
                }//end run method
            }//end inner anonymous class
        );//end call to invokeLater        
    }//end method displayMessage
         
    
    //send message to server 
    public void sendData(String message){//clients sends attemt for move to server and looses his turn
            System.out.println("right before sending to server");
            output.format("%s\n", message);
            output.flush();            
        
    }//end method sendClickedSquare
    
    
}//end class ChessGameClient
