/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.ui.custom.components;

import com.ohell.client.ui.Util;
import com.ohell.client.ui.images.ImageIconFactory;
import com.ohell.data.Card;
import com.ohell.data.enums.CardColor;
import com.ohell.data.enums.CardStrength;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;

/**
 *
 * @author User
 */
public class CardJButton extends JButton {

    private Card card;
    private ImageIcon img;
    

    public CardJButton(Card card) {
        this.card = card;
        
        String cardName = Util.cardToImgName(card);
        img = ImageIconFactory.getCardImage(cardName);
        initButton();
    }

    public Card getCard() {
        return card;
    }

    private void initButton() {
        this.setIcon(img);
        this.setSize(img.getIconWidth(), img.getIconHeight());
        this.setBorder(null);
        this.setContentAreaFilled(false);
        this.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        this.setIconTextGap(0);
        this.setMargin(new java.awt.Insets(0, 0, 0, 0));
        this.setOpaque(false);
        this.setLocation(0, 0);
    }
}
