/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.ui.custom.components;

import com.ohell.client.data.GameBean;
import com.ohell.client.ui.*;
import com.ohell.data.Announce;
import com.ohell.data.Card;
import com.ohell.data.Player;
import com.ohell.rules.OhellRulesManager;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import sun.awt.OrientableFlowLayout;

/**
 *
 * @author User
 */
public class GameBoardJPanel extends JPanel {

    private static final int REMOVE_LAST_HAND_DELAY = 2000;
    private GameBean gameModel;
    public static double relativeStep = 0.25;

    private JPanel trumpCardPanel;
    private JPanel cardBackPanel;

    private JPanel topHolderPanel;
    private JPanel topCardsPanel;
    private JPanel bottomCardsPanel;    
    private JPanel leftCardsPanel;
    private JPanel rightCardsPanel;
    private JPanel bottomPlayerInfoPanel;
    private JPanel leftPlayerInfoPanel;
    private JPanel topPlayerInfoPanel;
    private JPanel rightPlayerInfoPanel;
    private JPanel centerPanel;
    private CardTableJPanel cardTable;
    private List<Location> locations;
    private int playedMovesCount = 0;
    private int firstPlayer;
    private List<Player> players;
    private CardGameMakeMove makeMove;

    public GameBoardJPanel(List<Card> cards, List<Player> players, CardGameMakeMove makeMove, GameBean gameModel) {
        this.gameModel = gameModel;
        this.makeMove = makeMove;

        //must deretmine on which seatIndex is currentPlayer - this is BottomLocation. Then locations will be added by seatIndexes - the location of 0,the location of 1 etc.
        int currentPlayerSeatIndex = gameModel.getSeatIndexOfHostPlayer();
        prepareLocations(currentPlayerSeatIndex);

        initComponents(cards, players);
        this.setSize(550, 550);
        this.setPreferredSize(new Dimension(550, 550));
        this.setVisible(true);
    }

    private void initComponents(List<Card> cards, List<Player> players) {
        OrientableFlowLayout orientableFlowLayout;

        cardTable = new CardTableJPanel("/com/ohell/client/ui/images/cards/");
        setCards(cards);

        topHolderPanel = new JPanel();
        topHolderPanel.setLayout(new BorderLayout());
        topCardsPanel = new JPanel();
        topCardsPanel.setLayout(new FlowLayout(FlowLayout.CENTER));


        //TODO : add here trump
        if (gameModel.getCurrentRound().getTrump() != null) {
            JButton trumpButton = new JButton();
            Card trumpCard = gameModel.getCurrentRound().getTrump();
            System.out.println(trumpCard);
            String trumpCardImgName = Util.cardToImgName(trumpCard);
            String imgPath = Util.IMAGE_DIRECTORY + trumpCardImgName;
            ImageIcon img = new ImageIcon(getClass().getResource(imgPath));
            trumpButton = Util.initButton(trumpButton, img);
            trumpCardPanel = new JPanel();
//            trumpCardPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
            trumpCardPanel.add(trumpButton, BorderLayout.WEST);

            JButton cardBackButton = new JButton();
            imgPath = Util.IMAGE_DIRECTORY + "backV.png";
            img = new ImageIcon(getClass().getResource(imgPath));
            cardBackButton = Util.initButton(cardBackButton, img);
            cardBackPanel = new JPanel();
//            cardBackPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
            cardBackPanel.add(cardBackButton, BorderLayout.EAST);
        }
        topCardsPanel.add(new CardImageJPanel(cards.size(), Location.TOP));
        if(trumpCardPanel != null){
            topHolderPanel.add(trumpCardPanel,BorderLayout.WEST);
        }
        topHolderPanel.add(topCardsPanel, BorderLayout.CENTER);
        if(cardBackPanel != null){
            topHolderPanel.add(cardBackPanel, BorderLayout.EAST);
        }        

        leftCardsPanel = new JPanel();
        orientableFlowLayout = new OrientableFlowLayout(FlowLayout.CENTER);
        orientableFlowLayout.orientVertically();
        leftCardsPanel.setLayout(orientableFlowLayout);
        leftCardsPanel.add(new CardImageJPanel(cards.size(), Location.LEFT));

        rightCardsPanel = new JPanel();
        orientableFlowLayout = new OrientableFlowLayout(FlowLayout.CENTER);
        orientableFlowLayout.orientVertically();
        rightCardsPanel.setLayout(orientableFlowLayout);
        rightCardsPanel.add(new CardImageJPanel(cards.size(), Location.RIGHT));

        this.setLayout(new BorderLayout());
        this.add(topHolderPanel, BorderLayout.NORTH);
//        this.add(topCardsPanel, BorderLayout.NORTH);
        this.add(rightCardsPanel, BorderLayout.EAST);
        this.add(leftCardsPanel, BorderLayout.WEST);
        this.add(bottomCardsPanel, BorderLayout.SOUTH);


        initPlayersOnBoard(orientableFlowLayout);

        centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add(bottomPlayerInfoPanel, BorderLayout.SOUTH);
        centerPanel.add(leftPlayerInfoPanel, BorderLayout.WEST);
        centerPanel.add(topPlayerInfoPanel, BorderLayout.NORTH);
        centerPanel.add(rightPlayerInfoPanel, BorderLayout.EAST);
        JPanel tmp = new JPanel(new FlowLayout(FlowLayout.CENTER));
        tmp.add(cardTable);
        centerPanel.add(tmp, BorderLayout.CENTER);

        this.add(centerPanel, BorderLayout.CENTER);
    }

    private void initPlayersOnBoard(OrientableFlowLayout orientableFlowLayout) {
        //TODO : refactor taken hands code

        int firstToPlay = gameModel.getPlayerToPlayNext();

        //init Bottom
        int playerSeatIndex = gameModel.getSeatIndexOfHostPlayer();
        Player player = gameModel.getPlayerAtSeatIndex(playerSeatIndex);
        bottomPlayerInfoPanel = new JPanel(new FlowLayout(FlowLayout.CENTER));
        bottomPlayerInfoPanel.add(new PlayerInfoJPanel(player.getNickname(), Location.BOTTOM, 5, playerSeatIndex == firstToPlay));

        //init Left
        playerSeatIndex = OhellRulesManager.nextPlayerToAct(playerSeatIndex);
        player = gameModel.getPlayerAtSeatIndex(playerSeatIndex);
        orientableFlowLayout = new OrientableFlowLayout(FlowLayout.CENTER);
        orientableFlowLayout.orientVertically();
        leftPlayerInfoPanel = new JPanel(orientableFlowLayout);
        leftPlayerInfoPanel.add(new PlayerInfoJPanel(player.getNickname(), Location.LEFT, 5, playerSeatIndex == firstToPlay));

        //init Top
        playerSeatIndex = OhellRulesManager.nextPlayerToAct(playerSeatIndex);
        player = gameModel.getPlayerAtSeatIndex(playerSeatIndex);
        topPlayerInfoPanel = new JPanel(new FlowLayout(FlowLayout.CENTER));
        topPlayerInfoPanel.add(new PlayerInfoJPanel(player.getNickname(), Location.TOP, 3, playerSeatIndex == firstToPlay));

        //init Ritght
        playerSeatIndex = OhellRulesManager.nextPlayerToAct(playerSeatIndex);
        player = gameModel.getPlayerAtSeatIndex(playerSeatIndex);
        orientableFlowLayout = new OrientableFlowLayout(FlowLayout.CENTER);
        orientableFlowLayout.orientVertically();
        rightPlayerInfoPanel = new JPanel(orientableFlowLayout);
        rightPlayerInfoPanel.add(new PlayerInfoJPanel(player.getNickname(), Location.RIGHT, 2, playerSeatIndex == firstToPlay));
    }

    public void setCards(List<Card> cards) {
        bottomCardsPanel = new JPanel();
        FlowLayout flowLayout = new FlowLayout(FlowLayout.CENTER);
        bottomCardsPanel.setLayout(flowLayout);
        bottomCardsPanel.add(new CardJPanel(cards, makeMove, cardTable, gameModel, this));

    }

    public void setFirstPlayer(int playerIndex) {
        firstPlayer = playerIndex;
    }

    public void updateBoardWithAnnounceMade(int seatIndex, Announce announce){
        int nextPlayerToPlay = gameModel.getPlayerToPlayNext();
        int lastPlayedPlayer = gameModel.getLastPlayedPlayer();
        
        //TODO : refresh playerInfo panel with the made announce

        updateArrowForNextOnTurn(lastPlayedPlayer, nextPlayerToPlay);
        repaint();
    }

    public void updateBoardWithCardMove(Card card, final CardGameMakeMove makeMove) {
        //in GameState first gameModel is updated, so that here everything is set up - card is played so prevPlayerOnTurn must be used here - and how is this modul supposed to know this?
        Location tmpLocation = locations.get(gameModel.getLastPlayedPlayer());
        updateWithPlayedCard(card, tmpLocation);
        repaint();
        System.out.println("gameModel.isCurrentHandOver(): "+gameModel.isCurrentHandOver());
        if (gameModel.isCurrentHandOver()) {
            Timer t = new Timer();
            t.schedule(new TimerTask() {

                @Override
                public void run() {
                    cardTable.removeCards();
                    gameModel.initNextHand(); // hand is over and round is not over - just init next hand
                    repaint();
                    if(gameModel.getCurrentRound().isRoundComplete()){
                        makeMove.requestNextRound(gameModel.getCurrentRound().getRoundNumber(), gameModel.getSeatIndexOfHostPlayer());
                    }
                }
            }, REMOVE_LAST_HAND_DELAY);
        }
    }

    private void updateWithPlayedCard(Card card, Location location) {
        int nextPlayerToPlay = gameModel.getPlayerToPlayNext();
        int lastPlayedPlayer = gameModel.getLastPlayedPlayer();

        cardTable.addCard(card, location);
        removeCardImage(location);
        updateArrowForNextOnTurn(lastPlayedPlayer, nextPlayerToPlay);
        repaint();
    }

    private void removeCardImage(Location location) {
        switch (location) {
            case TOP:
                ((CardImageJPanel) topCardsPanel.getComponent(0)).removeCard();
                break;
            case LEFT:
                ((CardImageJPanel) leftCardsPanel.getComponent(0)).removeCard();
                break;
            case RIGHT:
                ((CardImageJPanel) rightCardsPanel.getComponent(0)).removeCard();
                break;
            case BOTTOM:
                //card is removed from clickHandler of CardButton
                break;
        }
    }

    private void updateArrowForNextOnTurn(int lastPlayedPlayer, int nextPlayerToPlay) {
        Location nextLocation = locations.get(nextPlayerToPlay);
        PlayerInfoJPanel next = getPanelFromLocation(nextLocation);
        next.toggleOnTurn(true);

        if (lastPlayedPlayer != -1) {
            Location currentLocation = locations.get(lastPlayedPlayer);
            PlayerInfoJPanel current = getPanelFromLocation(currentLocation);
            current.toggleOnTurn(true);
        }
    }

    private PlayerInfoJPanel getPanelFromLocation(Location location) {
        PlayerInfoJPanel result = null;
        switch (location) {
            case TOP:
                result = (PlayerInfoJPanel) topPlayerInfoPanel.getComponent(0);
                break;
            case LEFT:
                result = (PlayerInfoJPanel) leftPlayerInfoPanel.getComponent(0);
                break;
            case RIGHT:
                result = (PlayerInfoJPanel) rightPlayerInfoPanel.getComponent(0);
                break;
            case BOTTOM:
                result = (PlayerInfoJPanel) bottomPlayerInfoPanel.getComponent(0);
                break;
        }
        return result;
    }

    private void prepareLocations(int currentPlayerSeatIndex) {
        locations = new ArrayList<Location>();

        switch (currentPlayerSeatIndex) {
            case 0:
                locations.add(Location.BOTTOM);
                locations.add(Location.LEFT);
                locations.add(Location.TOP);
                locations.add(Location.RIGHT);
                break;
            case 1:
                locations.add(Location.RIGHT);
                locations.add(Location.BOTTOM);
                locations.add(Location.LEFT);
                locations.add(Location.TOP);
                break;
            case 2:
                locations.add(Location.TOP);
                locations.add(Location.RIGHT);
                locations.add(Location.BOTTOM);
                locations.add(Location.LEFT);
                break;
            case 3:
                locations.add(Location.LEFT);
                locations.add(Location.TOP);
                locations.add(Location.RIGHT);
                locations.add(Location.BOTTOM);
                break;
        }
    }
}
