/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * GameUI.java
 *
 * Created on 2010-6-30, 16:29:55
 */
package com.ohell.client.ui.custom.components;

import com.ohell.client.data.GameBean;
import com.ohell.client.ui.CardGameMakeMove;
import com.ohell.client.ui.ClientToServerComm;
import com.ohell.client.ui.custom.components.announces.AnnouncePanel;
import com.ohell.client.ui.custom.components.score.ScoreTableModel;
import com.ohell.communication.clienttoserver.ReadyObject;
import com.ohell.data.Announce;
import com.ohell.data.Card;
import com.ohell.data.Player;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

/**
 *
 * @author User
 */
public class GameJPanel extends JPanel {

    //=================== GameBusinessLogic fields ===================================
    private GameBean gameModel = new GameBean();
    private int tableId;
    private ClientToServerComm comm;
    private Player player;
    private int seatIndexOfPlayer;
    private List<Player> players = new ArrayList<Player>();
    /**
     * This is very important - must be managed localy for the client application according to communication with server
     */
    private boolean isReadyForNextRound = false;
    private boolean myTurn = true;
    // UI components

    //=================== UI components ===================================================
    private AnnouncePanel announcePanel;
    private GameBoardJPanel board;
    private javax.swing.JPanel chatPanel;
    private javax.swing.JTextArea chatTextArea;
    private javax.swing.JTextField chatTextField;
    private javax.swing.JPanel infoPanel;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JButton sitButton;
    private javax.swing.JButton standUpButton;
    private javax.swing.JButton startButton;
    private javax.swing.JTabbedPane tabbedPane;
    private javax.swing.JPanel tablePanel;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    // End of UI components

    //constructor initializing GUI
    public GameJPanel(ClientToServerComm _comm) {
        this.comm = _comm;
        this.player = _comm.getPlayer();
        initComponents();

        chatTextField.addActionListener(
                new ActionListener() {
                    // send message to server

                    public void actionPerformed(ActionEvent event) {
                        String msg = event.getActionCommand();
                        comm.sendChatObject(msg);
                        chatTextField.setText("");
                        displayMessage(player.getNickname() + ": " + msg);
                    } // end method actionPerformed
                } // end anonymous inner class
                ); // end call to addActionListener

        startButton.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                isReadyForNextRound = true;
                comm.sendData(new ReadyObject(isReadyForNextRound));
            }
        });

        setVisible(true);

    }//end constructor

    public GameBean getGameModel() {
        return gameModel;
    }

    public void setGameModel(GameBean gameModel) {
        this.gameModel = gameModel;
    }

    public AnnouncePanel getAnnouncePanel() {
        return announcePanel;
    }

    public void setAnnouncePanel(AnnouncePanel announcePanel) {
        this.announcePanel = announcePanel;
    }

    /**
     * This is seatIndex of the player sent from the server.With it gameBusiness logic can perform
     * game actions in apporpriate time.
     */
    public int getSeatIndexOfPlayer() {
        return seatIndexOfPlayer;
    }

    /**
     * This is seatIndex of the player sent from the server.With it gameBusiness logic can perform
     * game actions in apporpriate time.
     */
    public void setSeatIndexOfPlayer(int seatIndexOfPlayer) {
        this.seatIndexOfPlayer = seatIndexOfPlayer;
    }

    public int getTableId() {
        return tableId;
    }

    public void setTableId(int tableId) {
        this.tableId = tableId;
    }

    public List<Player> getPlayers() {
        return players;
    }

//    public void setPlayers(List<Player> players) {
//        this.players = players;
//    }
    /**
     * This method must be called when GameStartingObject is received from server!
     */
    public void initGameStart(Map<Integer, Player> map) {
        //first init the GameModel and pass it to scoreTableModel so that table can calculate its cells
        gameModel.setPlayersSeatMap(map);
        gameModel.setSeatIndexOfHostPlayer(seatIndexOfPlayer);

        //after that set column names
        initScoreTable(map);
    }

    private void initScoreTable(Map<Integer, Player> map) {
        arrangeColumnNames(map);
        jTable1.repaint();
    }

    private void arrangeColumnNames(Map<Integer, Player> map) {
        System.out.println("all columns count : " + jTable1.getColumnModel().getColumnCount());
        for (int i = 0; i < 4; i++) {
            int columnIndex = 2 * i + 1;
            System.out.println("columnIndex : " + columnIndex);
            System.out.println("nickname : " + map.get(i).getNickname());
            jTable1.getColumnModel().getColumn(columnIndex).setHeaderValue(map.get(i).getNickname());
        }
    }

    //TODO : vasko suggests here players.add(int index,Player elem) method
    //TODO : refactor code with correct seatIndex logic
    public void startRound(List<Card> cards, Card trump, int roundIndex) {
        gameModel.initNextRound(roundIndex, trump);
        if (board != null) {
            //remove old board and old announcePanel - refresh logic requires re-writing of all code because of spageti code.            
            tablePanel.removeAll();
        }
        
        board = new GameBoardJPanel(cards, players, (CardGameMakeMove) comm, gameModel);
        tablePanel.add(board, BorderLayout.CENTER);
        this.announcePanel = new AnnouncePanel(gameModel, new ArrayList<Announce>(gameModel.getAnnounces().values()), (CardGameMakeMove) comm, board);
        tablePanel.add(this.announcePanel, BorderLayout.SOUTH);
        updateUI();
    }

    public GameBoardJPanel getBoard() {
        return board;
    }

    public void setBoard(GameBoardJPanel board) {
        this.board = board;
    }

    /**
     * Updates the UI with the player's Nickname. In current implementation the column in the score
     * table has its header value changed to the player's nickname.
     *     
     */
    public void addPlayerInGame(Player player) {
        System.out.println("UpdatePlayerInfo: " + player.getNickname());
        //current size-1 or the size before adding the player
        int playerEnterIndex = players.size();
        players.add(player);
        int columnIndex = playerEnterIndex * 2 + 1;
        jTable1.getColumnModel().getColumn(columnIndex).setHeaderValue(player.getNickname());
//        jTable1.getModel().setValueAt("0", ScoreTableModel.RESULT_ROW_INDEX, columnIndex);
        jTable1.getModel().setValueAt("0", 16, columnIndex);
        jTable1.repaint();
    }

    /**
     * TODO : in the fture redesign when there will be spectators of the game, this method should be
     * implemented so that spectators are notified in some way.
     */
    public void addSpectatorPlayer(Player player) {
        //TODO : implementn in future release
    }

    public void setTable(JTable t) {
        jTable1 = t;
    }

    public JTable getScoreTable() {
        return jTable1;
    }

    //displaying message in displayArea using event-dispatch thread
    public void displayMessage(final String message) {
        SwingUtilities.invokeLater(
                new Runnable() {

                    public void run() {
                        chatTextArea.append(message);
                        chatTextArea.append("\n");
                        //always scroll down
                        int endIndex = chatTextArea.getDocument().getLength() - 1;
                        chatTextArea.setCaretPosition(endIndex);
                    }//end run method
                }//end inner anonymous class
                );//end call to invokeLater
    }//end method displayMessage


    //send message to server
    public void sendData(String message) {//clients sends attemt for move to server and looses his turn
        System.out.println("right before sending to server");
//        output.format("%s\n", message);
//        output.flush();

    }//end method sendClickedSquare

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">
    private void initComponents() {

//        jTabbedPane3 = new javax.swing.JTabbedPane();
        infoPanel = new javax.swing.JPanel();
        sitButton = new javax.swing.JButton();
        startButton = new javax.swing.JButton();
        standUpButton = new javax.swing.JButton();
        tabbedPane = new javax.swing.JTabbedPane();
        chatPanel = new javax.swing.JPanel();
        chatTextField = new javax.swing.JTextField();
        jScrollPane3 = new javax.swing.JScrollPane();
        chatTextArea = new javax.swing.JTextArea();
        tablePanel = new javax.swing.JPanel();

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();

        setBackground(new java.awt.Color(0, 204, 51));
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));

        infoPanel.setBackground(new java.awt.Color(102, 255, 255));

        sitButton.setText("sit");
        sitButton.setOpaque(false);

        startButton.setText("start");
        startButton.setOpaque(false);
        startButton.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startButtonActionPerformed(evt);
            }
        });

        standUpButton.setText("stand up");
        standUpButton.setOpaque(false);

        chatPanel.setBackground(new java.awt.Color(102, 255, 255));

        chatTextField.setFont(new java.awt.Font("Arial", 0, 12));

        chatTextArea.setColumns(20);
        chatTextArea.setEditable(false);
        chatTextArea.setFont(new java.awt.Font("Arial", 0, 12));
        chatTextArea.setRows(5);
        jScrollPane3.setViewportView(chatTextArea);

        javax.swing.GroupLayout chatPanelLayout = new javax.swing.GroupLayout(chatPanel);
        chatPanel.setLayout(chatPanelLayout);
        chatPanelLayout.setHorizontalGroup(
                chatPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addComponent(chatTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 244, Short.MAX_VALUE).addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 244, Short.MAX_VALUE));
        chatPanelLayout.setVerticalGroup(
                chatPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(javax.swing.GroupLayout.Alignment.TRAILING, chatPanelLayout.createSequentialGroup().addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 131, Short.MAX_VALUE).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(chatTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)));

        tabbedPane.addTab("chat", chatPanel);

        jTable1.setModel(gameModel.getScoreTableModel());
        initColumns();
        jScrollPane1.setViewportView(jTable1);


        javax.swing.GroupLayout infoPanelLayout = new javax.swing.GroupLayout(infoPanel);
        infoPanel.setLayout(infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(
                infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(infoPanelLayout.createSequentialGroup().addComponent(sitButton).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(startButton).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(standUpButton).addGap(44, 44, 44)).addComponent(tabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 350, Short.MAX_VALUE).addGroup(javax.swing.GroupLayout.Alignment.TRAILING, infoPanelLayout.createSequentialGroup().addContainerGap().addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 350, Short.MAX_VALUE).addContainerGap()));
        infoPanelLayout.setVerticalGroup(
                infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 291, javax.swing.GroupLayout.PREFERRED_SIZE).addGap(18, 18, 18).addGroup(infoPanelLayout.createSequentialGroup().addContainerGap().addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)).addGap(350, 350, 350).addGroup(infoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(sitButton).addComponent(startButton).addComponent(standUpButton)).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(tabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)));

        tablePanel.setPreferredSize(new java.awt.Dimension(550, 550));

//        javax.swing.GroupLayout tablePanelLayout = new javax.swing.GroupLayout(tablePanel);
//        tablePanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        tablePanel.setLayout(new BorderLayout());
//        tablePanelLayout.setHorizontalGroup(
//            tablePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
//            .addGap(0, 533, Short.MAX_VALUE)
//        );
//        tablePanelLayout.setVerticalGroup(
//            tablePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
//            .addGap(0, 533, Short.MAX_VALUE)
//        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(tablePanel, javax.swing.GroupLayout.PREFERRED_SIZE, 550, javax.swing.GroupLayout.PREFERRED_SIZE).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(infoPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)));
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addComponent(infoPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE).addComponent(tablePanel, javax.swing.GroupLayout.PREFERRED_SIZE, 550, javax.swing.GroupLayout.PREFERRED_SIZE));

//        pack();
    }// </editor-fold>

    private void initColumns() {
        jTable1.getTableHeader().setResizingAllowed(false);
        jTable1.getTableHeader().setReorderingAllowed(false);
        //set roundNumber column to be small
        jTable1.getColumnModel().getColumn(0).setPreferredWidth(25);

        //set player handAnnounce column to be small
        jTable1.getColumnModel().getColumn(2).setPreferredWidth(25);
        jTable1.getColumnModel().getColumn(4).setPreferredWidth(25);
        jTable1.getColumnModel().getColumn(6).setPreferredWidth(25);
        jTable1.getColumnModel().getColumn(8).setPreferredWidth(25);
    }

    private void startButtonActionPerformed(java.awt.event.ActionEvent evt) {
        // TODO add your handling code here:
    }
}
