/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.ui.custom.components;

import com.ohell.client.ui.Location;
import com.ohell.client.ui.images.ImageIconFactory;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 *
 * @author User
 */
public class PlayerInfoJPanel extends JPanel {

    private String nickname;
    private Location location;
    private int handsAnnounced;
    private int handsTaken;
    private boolean isOnTurn;
    private JLabel nicknameLabel;
    private JLabel turnLabel;
    private JLabel handsLabel;

    public PlayerInfoJPanel(String nickname, Location location, int handsAnnounced, boolean isOnTurn) {
        super();
        this.nickname = nickname;
        this.location = location;
        this.handsAnnounced = handsAnnounced;
        this.handsTaken = 0;

        nicknameLabel = new JLabel(this.nickname + " ");
        handsLabel = new JLabel(" " + handsTaken + "/" + handsAnnounced);
        turnLabel = new JLabel();

        //toggle will change isOnTurn to correct state
        this.isOnTurn = !isOnTurn;
        toggleOnTurn(false);

//        nicknameLabel.setVerticalAlignment(JLabel.CENTER);
//        nicknameLabel.setHorizontalAlignment(JLabel.CENTER);
//        handsLabel.setVerticalAlignment(JLabel.CENTER);
//        handsLabel.setHorizontalAlignment(JLabel.CENTER);
//        turnLabel.setVerticalAlignment(JLabel.CENTER);
//        turnLabel.setHorizontalAlignment(JLabel.CENTER);

        updateSize();
        if (location == Location.LEFT ||
                location == Location.RIGHT) {
            this.setLayout((new BoxLayout(this, BoxLayout.PAGE_AXIS)));
        } else {
            this.setLayout(new BoxLayout(this, BoxLayout.LINE_AXIS));
        }
        add(nicknameLabel);
        add(turnLabel);
        add(handsLabel);
    }

    private void updateSize() {
        int panelHeight = 0;
        int panelWidth = 0;

        if (location == Location.LEFT ||
                location == Location.RIGHT) {
            panelHeight += turnLabel.getPreferredSize().height;
            panelHeight += nicknameLabel.getPreferredSize().height;
            panelHeight += handsLabel.getPreferredSize().height;
            panelWidth = Math.max(turnLabel.getPreferredSize().width,
                    nicknameLabel.getPreferredSize().width);
            panelWidth = Math.max(panelWidth, handsLabel.getPreferredSize().width);
        } else {
            panelWidth += turnLabel.getPreferredSize().width;
            panelWidth += nicknameLabel.getPreferredSize().width;
            panelWidth += handsLabel.getPreferredSize().width;
            panelHeight = Math.max(turnLabel.getPreferredSize().height,
                    nicknameLabel.getPreferredSize().height);
            panelHeight = Math.max(panelHeight, handsLabel.getPreferredSize().height);
        }
        this.setPreferredSize(new Dimension((int) panelWidth, (int) panelHeight));
        this.setSize(panelWidth, panelHeight);
    }

    /**
     * Javadoc is good.
     * @param repaint - this is needed because when loading the panel, there is no parent component initialized yet, adn nullPointerException is thrown
     */
    public void toggleOnTurn(boolean repaint) {
        isOnTurn = (isOnTurn) ? false : true;
        String arrowName = null;
        if (isOnTurn) {
            switch (location) {
                case BOTTOM:
                    arrowName = "bottomArrow.png";
                    break;
                case LEFT:
                    arrowName = "leftArrow.png";
                    break;
                case RIGHT:
                    arrowName = "rightArrow.png";
                    break;
                case TOP:
                    arrowName = "topArrow.png";
                    break;
            }
        } else {
            if (location == Location.LEFT ||
                    location == Location.RIGHT) {
                arrowName = "notOnTurnH.png";

            } else {
                arrowName = "notOnTurnV.png";
            }
        }        
        
        ImageIcon img = ImageIconFactory.getArrowImage(arrowName);
        turnLabel.setIcon(img);
        this.updateUI();
        if (repaint) {
            this.getParent().repaint();
        }
        updateSize();
    }

    private void testDir() {
        File dir1 = new File(".");
        File dir2 = new File("..");
        try {
            System.out.println("Current dir : " + dir1.getCanonicalPath());
            System.out.println("Parent  dir : " + dir2.getCanonicalPath());
            System.out.println("Class canonical name: "+getClass().getCanonicalName());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void increaseHands() {
        handsTaken++;
        handsLabel.setText(" " + handsTaken + "/" + handsAnnounced);
        updateSize();

    }
}

