/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.ui.custom.components;

import com.ohell.client.ui.ClientToServerComm;
import com.ohell.communication.clienttoserver.EnterTableObject;
import com.ohell.data.GameTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

/**
 *
 * @author User
 */
public class TablesJPanel extends JPanel {

    private JButton joinButton;
    private List<GameTable> tables;
    private JTable tablesDisplay;
    private ClientToServerComm comm;

    public TablesJPanel(List<GameTable> tables, ClientToServerComm comm) {
        this.comm = comm;
        this.tables = tables;

        setLayout(new BorderLayout());

        String data[][] = new String[tables.size()][6];
        for (int i = 0; i < tables.size(); i++) {
            GameTable tmp = tables.get(i);
            data[i][0] = String.valueOf(tmp.getId());
            data[i][1] = tmp.getName();
            data[i][2] = tmp.getGameType();
            data[i][3] = (tmp.getIsActive()) ? "Yes" : "No";
            data[i][4] = String.valueOf(tmp.getGamesStarted());
            data[i][5] = String.valueOf(tmp.getGamesEnded());
        }
        String col[] = {"ID", "Name", "Type", "Active", "Games Started", "Games ended"};
        DefaultTableModel model = new DefaultTableModel(data, col);
        tablesDisplay = new JTable(model) {

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;   //Disallow the editing of any cell
            }
        };
        JTableHeader header = tablesDisplay.getTableHeader();
        header.setReorderingAllowed(false);
        header.setBackground(Color.yellow);
        JScrollPane pane = new JScrollPane(tablesDisplay);
        tablesDisplay.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        this.add(pane, BorderLayout.NORTH);

        joinButton = new JButton("Join");
        joinButton.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                sendData();
            }
        });
        this.add(joinButton, BorderLayout.SOUTH);

        this.setSize(700, 480);
    }

    private void sendData() {
        int selRowIndex = tablesDisplay.getSelectedRow();
        if (selRowIndex >= 0 && selRowIndex < tables.size()) {
            GameTable enteredTable = tables.get(selRowIndex);
            EnterTableObject o = new EnterTableObject(enteredTable.getId());
            comm.sendData(o);
        } else {
            JOptionPane.showMessageDialog(this, "Please select table");
        }
    }
}
