/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.client.ui.custom.components.announces;

import com.ohell.data.Announce;
import java.util.List;

/**
 * Announce panel should be bound to model bean that implements this interface.
 * Methods in it support all backing functionalities required by the announce panel in order
 * to maintain working game state
 * @author vasko
 */
public interface AnnounceBean {

    /**
     * @return the seatIndex of the Bottom positioned player that is host of the application
     * and who is to play using CardPanel - whose cards are visible.
     */
    public int getSeatIndexOfHostPlayer();

    /**
     * Implementation should update gameModel with player's announce
     * @param announce the announce value chosen by the player
     * @param seatIndex seatIndex of the player that made the announce
     */
    public void updateAnnounce(int seatIndex, Announce a);

    /**
     * Implementation should determine whether or not the announce panel is visible. Game rules suggest that 
     * player makes announce once every Round - after that, the panel should be invisible
     * @return true if announce panel should be displayed, false otherwise
     */
    public boolean isVisible();


    /**
     * There are blocked announces on every turn - for example player should not be able to make announce of 10 hands
     * in a round with 3 cards.
     * @return list with the CODES of all announces that a player can not make in this round
     */
    public List<Integer> getPossibleAnnounces();

}
