/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AnnouncePanel.java
 *
 * Created on Oct 3, 2010, 12:42:40 PM
 */
package com.ohell.client.ui.custom.components.announces;

import com.ohell.client.ui.CardGameMakeMove;
import com.ohell.client.ui.custom.components.GameBoardJPanel;
import com.ohell.data.Announce;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;

/**
 *
 * @author vasko
 */
public class AnnouncePanel extends javax.swing.JPanel{
    private HashMap<Integer, Announce> announceMap = new HashMap<Integer, Announce>();
    private AnnounceBean bean;
    private HashMap<Integer, JButton> buttonsMap = new HashMap<Integer, JButton>();
    private CardGameMakeMove makeMove;
    
    private GameBoardJPanel gameBoard;;

    /** Creates new form AnnouncePanel */
    public AnnouncePanel(AnnounceBean bean, List<Announce> announces, CardGameMakeMove makeMove, GameBoardJPanel board) {
        this.makeMove = makeMove;
        this.gameBoard = board;

        Announce a = null;
        for (int i = 0; i < announces.size(); i++) {
            a = announces.get(i);
            announceMap.put(i, a);
        }

        this.bean = bean;

        System.out.println("Before initComponents");
        initComponents();
        addButtonsInMap();
        System.out.println("after initComponents");
        setSize(450, 30);
        setVisible(true);
    }

    private void addButtonsInMap() {
        buttonsMap.put(0, jButton1);
        buttonsMap.put(1, jButton2);
        buttonsMap.put(2, jButton3);
        buttonsMap.put(3, jButton4);
        buttonsMap.put(4, jButton5);
        buttonsMap.put(5, jButton6);
        buttonsMap.put(6, jButton7);
        buttonsMap.put(7, jButton8);
        buttonsMap.put(8, jButton9);
        buttonsMap.put(9, jButton10);
        buttonsMap.put(10, jButton11);
        buttonsMap.put(11, jButton12);
        buttonsMap.put(12, jButton13);
        buttonsMap.put(13, jButton14);
    }

    public AnnounceBean getBean() {
        return bean;
    }

    public void setBean(AnnounceBean bean) {
        this.bean = bean;
    }

    public String getButtonName(int index) {
        Announce a = announceMap.get(index);
        if (a != null) {
            return a.getName();
        } else {
            return "";
        }
    }

    public boolean isButtonEnabled(int index) {
        if (!isPanelVisible()) {
            //in this case the panel will not be displayed so it doesnt matter what this method returs
            return false;
        } else {
            List<Integer> possibleAnnounces = bean.getPossibleAnnounces();            
            if (possibleAnnounces.contains(index)) {
                return true;
            } else {
                return false;
            }
        }
    }

    public boolean isPanelVisible() {
        return bean.isVisible();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jButton4 = new javax.swing.JButton();
        jButton5 = new javax.swing.JButton();
        jButton6 = new javax.swing.JButton();
        jButton7 = new javax.swing.JButton();
        jButton8 = new javax.swing.JButton();
        jButton9 = new javax.swing.JButton();
        jButton10 = new javax.swing.JButton();
        jButton11 = new javax.swing.JButton();
        jButton12 = new javax.swing.JButton();
        jButton13 = new javax.swing.JButton();
        jButton14 = new javax.swing.JButton();

        setEnabled(this.isPanelVisible());
        setPreferredSize(new java.awt.Dimension(420, 30));
        addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                formMouseClicked(evt);
            }
        });
        setLayout(new java.awt.GridBagLayout());

        jButton1.setText(this.getButtonName(0));
        jButton1.setEnabled(isButtonEnabled(0));
        jButton1.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton1.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton1.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton1.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton1, new java.awt.GridBagConstraints());

        jButton2.setText(this.getButtonName(1));
        jButton2.setEnabled(isButtonEnabled(1));
        jButton2.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton2.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton2.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton2.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton2, new java.awt.GridBagConstraints());

        jButton3.setText(this.getButtonName(2));
        jButton3.setEnabled(isButtonEnabled(2));
        jButton3.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton3.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton3.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton3.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton3, new java.awt.GridBagConstraints());

        jButton4.setText(this.getButtonName(3));
        jButton4.setEnabled(isButtonEnabled(3));
        jButton4.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton4.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton4.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton4.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton4, new java.awt.GridBagConstraints());

        jButton5.setText(this.getButtonName(4));
        jButton5.setEnabled(isButtonEnabled(4));
        jButton5.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton5.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton5.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton5.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton5, new java.awt.GridBagConstraints());

        jButton6.setText(this.getButtonName(5));
        jButton6.setEnabled(isButtonEnabled(5));
        jButton6.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton6.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton6.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton6.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton6, new java.awt.GridBagConstraints());

        jButton7.setText(this.getButtonName(6));
        jButton7.setEnabled(isButtonEnabled(6));
        jButton7.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton7.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton7.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton7.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton7.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton7, new java.awt.GridBagConstraints());

        jButton8.setText(this.getButtonName(7));
        jButton8.setAlignmentY(0.0F);
        jButton8.setEnabled(isButtonEnabled(7));
        jButton8.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton8.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton8.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton8.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton8.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton8, new java.awt.GridBagConstraints());

        jButton9.setText(this.getButtonName(8));
        jButton9.setAlignmentY(0.0F);
        jButton9.setEnabled(isButtonEnabled(8));
        jButton9.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton9.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton9.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton9.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton9.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton9, new java.awt.GridBagConstraints());

        jButton10.setText(this.getButtonName(9));
        jButton10.setEnabled(isButtonEnabled(9));
        jButton10.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton10.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton10.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton10.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton10.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton10, new java.awt.GridBagConstraints());

        jButton11.setText(this.getButtonName(10));
        jButton11.setAlignmentY(0.0F);
        jButton11.setEnabled(isButtonEnabled(10));
        jButton11.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton11.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton11.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton11.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton11.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton11, new java.awt.GridBagConstraints());

        jButton12.setText(this.getButtonName(11));
        jButton12.setAlignmentY(0.0F);
        jButton12.setEnabled(isButtonEnabled(11));
        jButton12.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton12.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton12.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton12.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton12.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton12, new java.awt.GridBagConstraints());

        jButton13.setText(this.getButtonName(11));
        jButton13.setAlignmentY(0.0F);
        jButton13.setEnabled(isButtonEnabled(12));
        jButton13.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton13.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton13.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton13.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton13.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton13, new java.awt.GridBagConstraints());

        jButton14.setText(this.getButtonName(12));
        jButton14.setAlignmentY(0.0F);
        jButton14.setEnabled(isButtonEnabled(13));
        jButton14.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton14.setMaximumSize(new java.awt.Dimension(30, 30));
        jButton14.setMinimumSize(new java.awt.Dimension(30, 30));
        jButton14.setPreferredSize(new java.awt.Dimension(30, 30));
        jButton14.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clickHandler(evt);
            }
        });
        add(jButton14, new java.awt.GridBagConstraints());
    }// </editor-fold>//GEN-END:initComponents

    private void formMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseClicked
        // TODO add your handling code here:        
    }//GEN-LAST:event_formMouseClicked

    private void clickHandler(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clickHandler
        // TODO add your handling code here:
        int btnIndex = -1;
        Object o = evt.getSource();
        if(o.equals(jButton1)){
            btnIndex = 0;
        }else if(o.equals(jButton2)){
            btnIndex = 1;
        }else if(o.equals(jButton3)){
            btnIndex = 2;
        }else if(o.equals(jButton4)){
            btnIndex = 3;
        }else if(o.equals(jButton5)){
            btnIndex = 4;
        }else if(o.equals(jButton6)){
            btnIndex = 5;
        }else if(o.equals(jButton7)){
            btnIndex = 6;
        }else if(o.equals(jButton8)){
            btnIndex = 7;
        }else if(o.equals(jButton9)){
            btnIndex = 8;
        }else if(o.equals(jButton10)){
            btnIndex = 9;
        }else if(o.equals(jButton11)){
            btnIndex = 10;
        }else if(o.equals(jButton12)){
            btnIndex = 11;
        }else if(o.equals(jButton13)){
            btnIndex = 12;
        }else if(o.equals(jButton14)){
            btnIndex = 13;
        }

        if(btnIndex != -1){
            Announce madeAnnounce = announceMap.get(btnIndex);
            bean.updateAnnounce(bean.getSeatIndexOfHostPlayer(),madeAnnounce);
            if(makeMove != null){
                makeMove.makeAnnounce(madeAnnounce);
            }
            if(gameBoard != null){
                gameBoard.updateBoardWithAnnounceMade(bean.getSeatIndexOfHostPlayer(),madeAnnounce);
            }
            refreshAnnouncePanel();

            //add-hock VIEW refreshing after model change
            gameBoard.getParent().repaint();
        }
    }//GEN-LAST:event_clickHandler

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton10;
    private javax.swing.JButton jButton11;
    private javax.swing.JButton jButton12;
    private javax.swing.JButton jButton13;
    private javax.swing.JButton jButton14;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JButton jButton7;
    private javax.swing.JButton jButton8;
    private javax.swing.JButton jButton9;
    // End of variables declaration//GEN-END:variables

    public void refreshAnnouncePanel() {
        setVisible(bean.isVisible());
        if (bean.isVisible()) {
            for (int i = 0; i < 14; i++) {
                refreshButtonEnabled(i);
            }
        }
    }

    private void refreshButtonEnabled(int buttonNumber) {
        buttonsMap.get(buttonNumber).setEnabled(isButtonEnabled(buttonNumber));
    }

    @Override
    public void paint(Graphics g){
        System.out.println("AnnouncePanel repaint(g)");
        super.paint(g);
        refreshAnnouncePanel();
    }

    @Override
    public void update(Graphics g){
        System.out.println("AnnouncePanel update(g)");
        this.paint(g);
    }
}
