/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.client.ui.custom.components.score;

import com.ohell.data.Player;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;

/**
 *
 * @author vasko
 */
public class ScoreTableTestFrame extends JFrame {

    private ScoreTablePanel scoreTable;

    public ScoreTableTestFrame(List<Player> players) {

        

        scoreTable = new ScoreTablePanel(players);        
        add(scoreTable,BorderLayout.NORTH);

        setSize(600, 400);
        setResizable(false);
        setVisible(true);
        setTitle("Score Table");
        setDefaultCloseOperation(EXIT_ON_CLOSE);

        JButton b = new JButton("Change");
        b.setSize(20, 20);
        b.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                scoreTable.getModel().setValueAt("###", 0, 0);
                scoreTable.repaint();
            }
        });
        add(b,BorderLayout.SOUTH);
    }



    public static void main(String[] args) {
        List<Player> testPlayers = new ArrayList<Player>();
        Player p1 = new Player();
        p1.setNickname("Player 1");
        testPlayers.add(p1);
        Player p2 = new Player();
        p2.setNickname("Player 2");
        testPlayers.add(p2);
        Player p3 = new Player();
        p3.setNickname("Player 3");
        testPlayers.add(p3);
        Player p4 = new Player();
        p4.setNickname("Player 4");
        testPlayers.add(p4);

        ScoreTableTestFrame test = new ScoreTableTestFrame(testPlayers);

    }
}
