/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.client.ui.util;

import com.ohell.client.ui.util.data.CardStrengthOrder;
import com.ohell.client.ui.util.data.ColorOrder;
import com.ohell.data.CardBasic;
import com.ohell.rules.OhellRulesManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/**
 * Utility class for common operations over Cards, Game etc.
 * @author vasko
 */
public class CardUtil {

    public  static <T extends CardBasic> List<T> sortCards(List<T> unsorted,final ColorOrder colorOrder,final CardStrengthOrder stregthOrder){
        SortedSet<T> sortedSet = new TreeSet<T>(new Comparator<CardBasic>() {
            public int compare(CardBasic o1, CardBasic o2) {
                if(colorOrder.getIndexByCardColor(o1.getColor()) == colorOrder.getIndexByCardColor(o2.getColor())){
                    boolean isFirstBigger = OhellRulesManager.isFirstBiggerThanSecond(o1, o2);
                    switch(stregthOrder){
                        case ASC:
                            return isFirstBigger ? -1 : 1;
                        case DESC:
                            return isFirstBigger ? 1 : -1;
                        case SHUFFLE:
                            return System.currentTimeMillis()%2 == 0 ? -1 : 1;
                        default:
                            return isFirstBigger ? 1 : -1;
                    }
                }else{
                    return colorOrder.getIndexByCardColor(o1.getColor()) - colorOrder.getIndexByCardColor(o2.getColor());
                }
            }
        });

        for (T card : unsorted) {
            sortedSet.add(card);
        }

        List<T> result = new ArrayList<T>();
        Iterator<T> iterator = sortedSet.iterator();
        while(iterator.hasNext()){
            result.add(iterator.next());
        }

        return result;
    }
}
