package com.ohell.server.ui;

import com.ohell.data.GameTable;
import com.ohell.persistence.builders.QueryBuilderException;
import com.ohell.persistence.dao.PersistenceManagerDAO;
import com.ohell.threads.OhellPlayerThread;
import com.ohell.threads.OhellTableCommunicationMediator;
import java.awt.BorderLayout;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JFrame;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

/**
 *
 * @author Vasko
 */
public class OhellGameServer extends JFrame implements TableCommunicationMediatorsHolder {

    public static final String SERVER_NICK_NAME = "Server";
    private JTextArea displayArea;
    private ServerSocket server; //to establish connection with clients
    private OhellPlayerThread[] players; //array for the players
    private ExecutorService gameExecutor; //responsible for running players
    private static final int playersCount = 4;
    private static final int SERVER_PORT = 11111; //TODO : use config file
//    private List<GameTable> tables;
    private List<OhellTableCommunicationMediator> tableChatMediators;

    //constructor initializing server and GUI for messages
    public OhellGameServer() {
        super("Vasko's simple chat server.All rights reserved!"); //sets window's title
        //Creating ExecutorService - each player will be run in different thread
        gameExecutor = Executors.newFixedThreadPool(playersCount);

        players = new OhellPlayerThread[playersCount];
        //! ServerSocket
        try {
            server = new ServerSocket(SERVER_PORT, playersCount);//port is 11111 , queue max 2 connection attempts
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        //GUI part
        displayArea = new JTextArea();
        displayArea.setEditable(false);
        add(displayArea, BorderLayout.CENTER);
        displayArea.setText("Server waiting for connections\n");
        setSize(300, 300);//window size
        setVisible(true);//shows window
    }//end ChessGameServer constructor

    //waits for two connections and uses gameExecutor to start game
    public void startApplication() {

//        initialize tables
        initTables();

        for (int i = 0; i < players.length; i++) {
            try {
                System.out.println("Init of player Thread");
                //here tables and tableChatMediators are already initialized so it is safe to pass 'this' to playerThreads
                players[i] = new OhellPlayerThread(server.accept(), i, this);
                gameExecutor.execute(players[i]);                
            } catch (IOException ioe) {
                ioe.printStackTrace();
            }//end try catch
        }//end for
    }//end method waitForPlayers

    private void initTables() {
        //fetch all Active tables from DB
        try {
            GameTable t = new GameTable();
            t.setIsActive(true);
            List<GameTable> tables = PersistenceManagerDAO.findByExample(t);
            if (null != tables && tables.size() > 0) {
                tableChatMediators = new ArrayList<OhellTableCommunicationMediator>(tables.size());
                for (GameTable table : tables) {
                    OhellTableCommunicationMediator temp = new OhellTableCommunicationMediator(table);
                    tableChatMediators.add(temp);
                }
            }
        } catch (QueryBuilderException e) {
            e.printStackTrace();
            System.out.println("Error while fetching tables in server initTalbes: " + e.getMessage());
        }
    }
    /*
    public static void main(String[] args) {
    OhellGameServer ts = new OhellGameServer();
    ts.startApplication();
    }
     */

    public List<OhellTableCommunicationMediator> getTableCommunicationMediatorsFromServer() {
        return tableChatMediators;
    }

    private void displayMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                displayArea.append("\n");
                displayArea.append(message);
            }
        });
    }

    //simple implementation - messages are added to a textArea
    public void log(String message) {
        displayMessage(message);
    }
}

