/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.threads;

import com.ohell.communication.clienttoserver.EnterTableObject;
import com.ohell.communication.clienttoserver.LoginObject;
import com.ohell.communication.clienttoserver.ReadyObject;
import com.ohell.communication.clienttoserver.RoundOverObject;
import com.ohell.communication.common.AnnounceObject;
import com.ohell.communication.common.ChatObject;
import com.ohell.communication.common.PlayedMoveObject;
import com.ohell.communication.common.PlayerObject;
import com.ohell.communication.servertoclient.ChosenTableObject;
import com.ohell.communication.servertoclient.FailLoginObject;
import com.ohell.communication.servertoclient.TablesObject;
import com.ohell.data.CardGame;
import com.ohell.data.GameTable;
import com.ohell.data.Player;
import com.ohell.persistence.builders.QueryBuilderException;
import com.ohell.persistence.dao.PersistenceManagerDAO;
import com.ohell.server.service.AuthenticationService;
import com.ohell.server.ui.TableCommunicationMediatorsHolder;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.List;

/**
 *
 * @author vasko
 */
public class OhellPlayerThread implements Runnable, OhellCommunicationObserver {

    private Socket connection;//socket for connection with Client application
    private ObjectInputStream inputStream;
    private ObjectOutputStream outputSream;
    private int playerNumber;//shows which player this is        
    private OhellTableCommunicationMediator communicationMediator;
    private boolean playerIsReady = false;
    /**
     * current thread's player object should be saved so its nickname is available in this playerThread object and chatTableMediator can use it to send messages with appropriate nickname
     */
    private Player player;
    /**
     * Check documentation in the TableChatMEdiatorsHolder class
     */
    private TableCommunicationMediatorsHolder tableCommunicationMediatorsHolder;

    public Player getPlayer() {
        return player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public OhellTableCommunicationMediator getTableChatMediator() {
        return communicationMediator;
    }

    public void setTableChatMediator(OhellTableCommunicationMediator tableChatMediator) {
        this.communicationMediator = tableChatMediator;
    }

    //constructor
    public OhellPlayerThread(Socket socket, int number, TableCommunicationMediatorsHolder mediatorsHolder) {
        //initializing
        this.tableCommunicationMediatorsHolder = mediatorsHolder;
        playerNumber = number;
        connection = socket;
        try {//obtain streams from connection socket

            //very important to flush the first communication header for the corresponding output stream
            //otherwise , the corresponding new ObjectInputStream constructor will block forever
            outputSream = new ObjectOutputStream(connection.getOutputStream());
            outputSream.flush();

            inputStream = new ObjectInputStream(connection.getInputStream());
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } //end try catch
    }//end constructor

    //this is what thread will do:
    public void run() {
        System.out.println("It is in the run method of player thread " + Thread.currentThread());
        //sending  messages to players
        try {// use try to close socket in finally statement
            while (true) {
                try {
                    Object o = inputStream.readObject();
                    System.out.println("Class of communicationo object is: " + o.getClass());
                    processCommunicationObject(o);
                } catch (EOFException eof) {
                    //user terminates client application - socket is closed in finally block
                    System.out.println("EOF caurght - player has left the server");
                    tableCommunicationMediatorsHolder.log(this.player.getNickname() + " has left the server");
                    break;
                } catch (IOException e) {
                    System.out.println("IOException caught: " + e.getMessage());
                    break;
                } catch (ClassNotFoundException e) {
                    System.out.println("ClassNotFoundException: " + e.getMessage());
                }
            }//end while
        }//end try
        finally {//use try finally to close socket
            try {
                connection.close();
            } catch (IOException ioe) {
                ioe.printStackTrace();
            }//end try catch
        }//end finally
    }//end run method

    private void processCommunicationObject(Object o) {
        if (o instanceof LoginObject) {
            processLoginCommunicationObject((LoginObject) o);
        } else if (o instanceof EnterTableObject) {
            processEnterTableObject((EnterTableObject) o);
        } else if (o instanceof ChatObject) {
            processChatObject((ChatObject) o);
        } else if (o instanceof ReadyObject) {
            processReadyObject((ReadyObject) o);
        } else if (o instanceof PlayedMoveObject) {
            processPlayedMoveObject((PlayedMoveObject) o);
        } else if (o instanceof AnnounceObject) {
            processAnnouncedObject((AnnounceObject) o);
        } else if (o instanceof RoundOverObject) {
            processRoundOverObject((RoundOverObject) o);
        } else {
            //TODO : handle more communication objects!!
        }
    }

    private void processRoundOverObject(RoundOverObject roo) {
        int serverRoundNumber = communicationMediator.getGame().currentRound().getRoundNumber();
        int clientRoundNumber = roo.getRoundNumber();
        if (serverRoundNumber != clientRoundNumber) {
            System.out.println("Error - ServerRound and ClientRound does not match!!");
            //TODO : implement check if roundNumber coincide
        } else {
            communicationMediator.updateRoundOverState(roo.getPlayerSeatIndex());
        }
    }

    private void processAnnouncedObject(AnnounceObject ao) {
        communicationMediator.getGame().makeAnnounce(this.getPlayer(), ao.getAnnounce());

        //send move to other players
        long playerSeatIndex = communicationMediator.getPlayerIdFromSeatIndex(ao.getSeatIndex());
        communicationMediator.updateCommunicationState(playerSeatIndex, ao);
    }

    private void processPlayedMoveObject(PlayedMoveObject pmo) {
        //update Game business logic
        communicationMediator.getGame().makeMove(this.getPlayer(), pmo.getPlayedCard());

        //send move to other players
        long playerId = communicationMediator.getPlayerIdFromSeatIndex(pmo.getSeatIndex());
        communicationMediator.updateCommunicationState(playerId, pmo);
    }

    private void processChatObject(ChatObject o) {
        //chat is forbiden in the clients if a client is associated with a table
        //however it is good practise to check the NullPointerException  here
        if (communicationMediator != null) {
            communicationMediator.updateCommunicationState(o.getPlayer().getId(), o);
        }
    }

    private void processLoginCommunicationObject(LoginObject lo) {
        String nickname = lo.getNickname();
        String password = lo.getPassword();

        Player loginPlayer = AuthenticationService.getInstance().loginUser(nickname, password);
        if (loginPlayer != null) {
            this.tableCommunicationMediatorsHolder.log(nickname + " has entered the server.");

            //set current thread's player object that just have logged in so that its nickname is stored in this playerThread object and chatTableMediator can use it to send messages with appropriate nickname
            player = loginPlayer;
            //if user is authenticated server should send the active tablest
            try {
                //first send player object indicating a successful login
                PlayerObject po = new PlayerObject(loginPlayer);
                sendObject(po);

                //then send all active tables
                GameTable table = new GameTable();
                table.setIsActive(true);
                List<GameTable> activeTables = PersistenceManagerDAO.findByExample(table);
                TablesObject to = new TablesObject();
                to.setTables(activeTables);
                sendObject(to);
            } catch (QueryBuilderException e) {
                System.out.println("Error while fetching active tables from DB");
                e.printStackTrace();
            }
        } else {
            FailLoginObject flo = new FailLoginObject();
            sendObject(flo);
        }
    }

    private void processEnterTableObject(EnterTableObject eto) {
        //first the playerThread should subscribe to the appropriate OhellTableChatMediator
        List<OhellTableCommunicationMediator> tableMediators =
                this.tableCommunicationMediatorsHolder.getTableCommunicationMediatorsFromServer();

        //TODO : refactor data structure here, so that mediators are in HashMap<tableId, mediator> - performance optimization.
        for (OhellTableCommunicationMediator temp : tableMediators) {
            GameTable t = temp.getTable();
            if (t.getId() == eto.getTableId()) { // if the tableChatMediator is for the table entered by the client - do your magic                
                this.communicationMediator = temp;//store the mediator so that its ChatState can be updated from current playerThread
                this.communicationMediator.subscribeCommunicationObserver(this);//add this playerThread as observer for the mediator
                break;
            }
        }

        //second - the client should receive ChosenTableObject
        ChosenTableObject cto = new ChosenTableObject(communicationMediator.getTable());
        sendObject(cto);
        //third - notify all clients in the chosen table of the new player
        PlayerObject po = new PlayerObject(player);
        communicationMediator.updateCommunicationState(player.getId(), po);
    }

    private void processReadyObject(ReadyObject readyObject) {
        if (readyObject.isIsReadyForNextRound() != playerIsReady) {
            playerIsReady = readyObject.isIsReadyForNextRound();
            communicationMediator.updateReadyPlayerState(playerIsReady);
        }
    }

    public void sendObject(Object o) {
        try {
            outputSream.writeObject(o);
            outputSream.flush();
        } catch (IOException ex) {
            ex.printStackTrace();
        }

    }

//
//    public synchronized void updateWithChatObject(ChatObject chatObject) {
//        try {
//            outputSream.writeObject(chatObject);
//            outputSream.flush();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//    }
}
