/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.persistence.builders;

import com.ohell.data.Announce;
import com.ohell.data.Card;
import com.ohell.data.GameTable;
import com.ohell.data.Player;
import com.ohell.persistence.builders.impl.AnnounceQueryBuilderImpl;
import com.ohell.persistence.builders.impl.CardQueryBuilderImpl;
import com.ohell.persistence.builders.impl.PlayerQueryBuilderImpl;
import com.ohell.persistence.builders.impl.TableQueryBuilderImpl;


/**
 * Singleton Factory that is used to supply QueryBuilders for different DAOs
 * @author vasko
 */
public class BuildersFactory {

    private static final BuildersFactory builderFactory = new BuildersFactory();

    private BuildersFactory(){
    }

    public static BuildersFactory getInstance(){
        return builderFactory;
    }

    public <T> QueryBuilder<T> getQueryBuilder(T c) throws QueryBuilderException{
        if(c.getClass().equals(Player.class)){
            return (QueryBuilder<T>) new PlayerQueryBuilderImpl();
        }else if(c.getClass().equals(GameTable.class)){
            return (QueryBuilder<T>) new TableQueryBuilderImpl();
        }else if(c.getClass().equals(Card.class)){
            return (QueryBuilder<T>) new CardQueryBuilderImpl();
        }else if(c.getClass().equals(Announce.class)){
            return (QueryBuilder<T>) new AnnounceQueryBuilderImpl();
        }else{
            throw new QueryBuilderException("Attempt to obtain invalid queryBuilder = QueryBuilder doesn't exist for class: " + c.getClass().getCanonicalName());
        }
    }
}
