/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.persistence.builders;

import com.ohell.data.GameTable;
import com.ohell.data.Player;
import com.ohell.data.Round;
import com.ohell.persistence.dao.PersistenceManagerDAO;
import java.util.List;

/**
 * Test class
 * @author vasko
 */
public class TestBuilderFactory {

    public static void main(String[] args) {

        addTable();

        addPlayersInDB();

        fetchPlayersWillWork();

//        fetchRoundsWillNotWork();

        fetchTables();
    }

    private static void addTable(){
        GameTable table = new GameTable();
        table.setName("Grinders Zone");
        table.setGameType("Ohell");
        table.setIsActive(true);
        table.setGamesStarted(0);
        table.setGamesEnded(0);

        table = PersistenceManagerDAO.saveObject(table);
        System.out.println("Table persisted:"+table);
    }

    private static void testLogin(){
        
    }

    private static void fetchTables() {
        GameTable table = new GameTable();
//        table.setGameType("Ohell");
        try {
            List<GameTable> tables = PersistenceManagerDAO.findByExample(table);
            for (GameTable t : tables) {
                System.out.println("Fetched GameTable - "+t);
            }
        } catch (QueryBuilderException e) {
            e.printStackTrace();
            System.out.println("Exception while fetching results from DB : " + e.getMessage());
        }
    }

    private static void fetchPlayersWillWork() {
        //this will work fine because there is implementation of PlayerQueryBuilder
        Player p = new Player();
        p.setNickname("M");
        try {
            List<Player> players = PersistenceManagerDAO.findByExample(p);
            for (Player player : players) {
                System.out.println("Fetched player with search for nickname like 'M%' - " + player);
            }
        } catch (QueryBuilderException e) {
            e.printStackTrace();
            System.out.println("Exception while fetching results from DB : " + e.getMessage());
        }
    }

    private static void fetchRoundsWillNotWork() {
        //This will not work because there is no builder for Round objects
        Round r = new Round();
        r.setRoundNumber(1);
        try {
            List<Round> rounds = PersistenceManagerDAO.findByExample(r);
            for (Round round : rounds) {
                System.out.println("Fetched rounds with search query:" + r + " - " + round);
            }
        } catch (QueryBuilderException e) {
            e.printStackTrace();
            System.out.println("Exception while fetching results from DB : " + e.getMessage());
        }
    }

    private static void addPlayersInDB() {
        Player pMazga = new Player();
        pMazga.setNickname("Mazga");
        pMazga.setPassword("mazga");
        pMazga.setGamesPlayed(3);
        pMazga.setGamesWon(0);

        Player pMOPKOB = new Player();
        pMOPKOB.setNickname("MOPKOB");
        pMOPKOB.setPassword("MOPKOB");
        pMOPKOB.setGamesPlayed(11);
        pMOPKOB.setGamesWon(7);

        Player pTomni = new Player();
        pTomni.setNickname("Tomni");
        pTomni.setPassword("12321");
        pTomni.setGamesPlayed(2);
        pTomni.setGamesWon(1);

        Player pJoker = new Player();
        pJoker.setNickname("Joker");
        pJoker.setPassword("Joker");
        pJoker.setGamesPlayed(0);
        pJoker.setGamesWon(0);

        pMazga = PersistenceManagerDAO.saveObject(pMazga);
        System.out.println("pMazga persisted with id: " + pMazga.getId());
        pMOPKOB = PersistenceManagerDAO.saveObject(pMOPKOB);
        System.out.println("pMOPKOB persisted with id: " + pMOPKOB.getId());
        pTomni = PersistenceManagerDAO.saveObject(pTomni);
        System.out.println("pTomni persisted with id: " + pTomni.getId());
        pJoker = PersistenceManagerDAO.saveObject(pJoker);
        System.out.println("pTomni persisted with id: " + pJoker.getId());
    }
}
