/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.persistence.builders.impl;

import com.ohell.data.Announce;
import com.ohell.persistence.builders.QueryBuilder;
import com.ohell.persistence.util.HibernateSessionUtil;
import org.hibernate.Query;
import org.hibernate.Session;

/**
 *
 * @author vasko
 */
public class AnnounceQueryBuilderImpl implements QueryBuilder<Announce> {

    private static class AnnounceSearchFields {

        public Integer code;
        public String name;
        public String gameType;
        //TODO : support name and gameType enums

        @Override
        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("Search fields: (");
            buff.append(code);
            buff.append(',');
            buff.append(name);
            buff.append(',');
            buff.append(gameType);
            buff.append(')');

            return buff.toString();
        }

        public boolean hasOneField() {
            return (null != code) || (null != name && !name.isEmpty()) || (null != gameType && !gameType.isEmpty());
        }

        public String getWhereAnnounce() {
            StringBuilder str = new StringBuilder();
            boolean hasFirst = false;

            if (null != code) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("code like :code ");
            }

            if (null != name && !name.isEmpty()) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("name like :name ");
            }
            
            if (null != gameType && !gameType.isEmpty()) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("gameType like :gameType ");
            }
            
            return str.toString();
        }

        public void setQueryParamsPlayer(Query query) {
            if (null != code) {
                query.setParameter("code", code); //"%" means that database record should contain but not exactly match the given param value
            }
            if (null != name && !name.isEmpty()) {
                query.setParameter("name", name); //"%" means that database record should contain but not exactly match the given param value
            }
            if (null != gameType && !gameType.isEmpty()) {
                query.setParameter("gameType", gameType); //"%" means that database record should contain but not exactly match the given param value
            }
        }
    }

    public Query buildFindByExampleQueryDAO(Announce a) {
        AnnounceSearchFields fields = new AnnounceSearchFields();
        fields.code = a.getCode() == -1 ? null : a.getCode();
        fields.name = a.getName() == null ? null : a.getName();
        fields.gameType = a.getGameType() == null ? null : a.getGameType();

        Session session = HibernateSessionUtil.getSession();
        session.clear();//to clear old query if it has cached result set for optimization

        // search Certlett objects
        String hql = "from Announce a ";
        if (fields.hasOneField()) {
            hql += "where ";
            hql += fields.getWhereAnnounce();

            System.out.println("Query text: " + hql);
        }
        Query q = session.createQuery(hql);
        fields.setQueryParamsPlayer(q);

        return q;
    }
}
