/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.persistence.builders.impl;

import com.ohell.data.Card;

import com.ohell.persistence.builders.QueryBuilder;
import com.ohell.persistence.util.HibernateSessionUtil;
import org.hibernate.Query;
import org.hibernate.Session;

/**
 *
 * @author vasko
 */
public class CardQueryBuilderImpl implements QueryBuilder<Card>{

    private static class CardSearchFields{

        public String color;
        public String strength;

        @Override
        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("Search fields: (");
            buff.append(color);
            buff.append(',');
            buff.append(strength);
            buff.append(')');

            return buff.toString();
        }

        public boolean hasOneField() {
            return (null != color && !color.isEmpty()) || (null != strength && !strength.isEmpty());
        }

        public String getWherePlayer() {
            StringBuilder str = new StringBuilder();
            boolean hasFirst = false;

            if (null != color && !color.isEmpty()) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("color like :color ");
            }

            if (null != strength && !strength.isEmpty()) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("strength like :strength ");
            }

            return str.toString();
        }

        public void setQueryParamsPlayer(Query query) {
            if (null != color && !color.isEmpty()) {
                query.setParameter("color", color); //"%" means that database record should contain but not exactly match the given param value
            }
            if (null != strength && !strength.isEmpty()) {
                query.setParameter("strength", strength); //"%" means that database record should contain but not exactly match the given param value
            }           
        }
    }

    public Query buildFindByExampleQueryDAO(Card c) {
        CardSearchFields fields = new CardSearchFields();       
        fields.color = c.getColor() == null ? null : c.getColor().name();
        fields.strength = c.getStrength() == null ? null : c.getStrength().name();
        
        Session session = HibernateSessionUtil.getSession();
        session.clear();//to clear old query if it has cached result set for optimization

        // search Certlett objects
        String hql = "from Card c ";
        if (fields.hasOneField()) {
            hql += "where ";
            hql += fields.getWherePlayer();

            System.out.println("Query text: " + hql);
        }
        Query q = session.createQuery(hql);
        fields.setQueryParamsPlayer(q);

        return q;
    }

}
