/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.persistence.builders.impl;

import com.ohell.data.OhellGame;
import com.ohell.data.Player;
import com.ohell.data.ScoreTable;
import com.ohell.persistence.builders.QueryBuilder;
import com.ohell.persistence.builders.QueryBuilderException;
import com.ohell.persistence.dao.PersistenceManagerDAO;
import com.ohell.persistence.util.HibernateSessionUtil;
import com.ohell.relations.GamePlayerRel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

/**
 *
 * @author vasko
 */
public class GameQueryBuilderImpl implements QueryBuilder<OhellGame>{

    
     private static class GameSearchFields{

        public String playerNickname;

        @Override
        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("Search fields: (");
            buff.append(playerNickname);
            buff.append(')');

            return buff.toString();
        }

        public boolean hasOneField() {
            return (null != playerNickname && !playerNickname.isEmpty());
        }


        public void setQueryParamsPlayer(Query query) {
            if (null != playerNickname && !playerNickname.isEmpty()) {
                query.setParameter("playerNickname", playerNickname+"%");
            }           
        }
    }



    public Query buildFindByExampleQueryDAO(OhellGame object) {
        throw new UnsupportedOperationException("Not supported yet");
    }


//===================================== Test Methods ========================================

    private static void testFetchGameByPlayerParams(){
        Session session = HibernateSessionUtil.getSession();
        session.clear();

        String hql = "select g from OhellGame g, GamePlayerRel r " +
                     "where (r.player.nickname like :arg0) and (r in elements(g.gamePlayerRels))";

        Query q = session.createQuery(hql);
        String nickname = "MOP%";
        q.setParameter("arg0", nickname);

        List<OhellGame> gList = q.list();
        
        if(gList != null && gList.size() > 0){
            for (OhellGame ohellGame : gList) {
                System.out.println("Game: "+ohellGame);
                System.out.println("");
            }
        }else{
            System.out.println("No game was fetched for player - "+nickname);
        }
    }

    private static void testHQL_getPlayersInGame(){
        Session session = HibernateSessionUtil.getSession();
        session.clear();//to clear old query if it has cached result set for optimization

        String hql = "select p from OhellGame g " +
                     "join g.gamePlayerRels rels " +
                     "join rels.player p " +
                     "where (g.id = :arg0) and (rels.seatIndex = :arg1)";

        Query q = session.createQuery(hql);
        q.setParameter("arg0", 2l);
        q.setParameter("arg1", 2);

        List<Player> pList = q.list();
        for (Player player : pList) {
            System.out.println("Fetched player with seatIndex=2 from game with id=1 : "+player);
        }
    }
    public static void main(String[] args) throws QueryBuilderException {
//        testFetchGameByPlayerParams();

        //test game create
//        testGameCreate();

//        fetchListTest();
        
        testHQL_getPlayersInGame();
    }

    private static void fetchListTest() throws QueryBuilderException{
        Session session = HibernateSessionUtil.getSession();
        session.clear();//to clear old query if it has cached result set for optimization

        String hql = "from OhellGame";
        Query q = session.createQuery(hql);       

        List<OhellGame> gList = q.list();
        OhellGame g = gList.get(0);
        List<GamePlayerRel> rels = g.getGamePlayerRels();
        System.out.println(rels.size());
    }
    
    

}
