/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.persistence.builders.impl;

import com.ohell.data.Player;
import com.ohell.persistence.builders.QueryBuilder;
import com.ohell.persistence.util.HibernateSessionUtil;
import org.hibernate.Query;
import org.hibernate.Session;

/**
 * Player QueryBuilder class that follows the DAO pattern for DB search queries
 * Receives DAO Player object and searches for objects with the same field values
 * @author vasko
 */
public class PlayerQueryBuilderImpl implements QueryBuilder<Player>{

    public PlayerQueryBuilderImpl() {
    }

    private static class PlayerSearchFields{

        public String nickname;
        public String password;
        public int gamesPlayed;
        public int gamesWon;


        @Override
        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("Search fields: (");
            buff.append(nickname);
            buff.append(',');
            buff.append(password);
            buff.append(',');
            buff.append(gamesPlayed);
            buff.append(',');
            buff.append(gamesWon);
            buff.append(')');

            return buff.toString();
        }

        public boolean hasOneField() {
            return (null != nickname && !nickname.isEmpty()) || (null != password && !password.isEmpty()) || (gamesPlayed > 0) || (gamesWon > 0);
        }

        public String getWherePlayer() {
            StringBuilder str = new StringBuilder();
            boolean hasFirst = false;

            if (null != nickname && !nickname.isEmpty()) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("nickname like :nickname ");
            }

            if (null != password && !password.isEmpty()) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("password like :password ");
            }

            if (gamesWon > 0) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("gamesWon like :gamesWon ");
            }
            if (gamesPlayed > 0) {
                if (hasFirst) {
                    str.append("and ");
                } else {
                    hasFirst = true;
                }
                str.append("gamesPlayed like :gamesPlayed ");
            }

            return str.toString();
        }

        public void setQueryParamsPlayer(Query query) {
            if (null != nickname && !nickname.isEmpty()) {
                query.setParameter("nickname", nickname); //"%" means that database record should contain but not exactly match the given param value
            }
            if (null != password && !password.isEmpty()) {
                query.setParameter("password", password); //"%" means that database record should contain but not exactly match the given param value
            }
            if (gamesWon > 0) {
                query.setParameter("gamesWon", gamesWon);
            }
            if (gamesPlayed > 0) {
                query.setParameter("gamesPlayed", gamesPlayed);
            }
        }
    }

    public Query buildFindByExampleQueryDAO(Player p) {
        
        PlayerSearchFields fields = new PlayerSearchFields();
        fields.nickname = p.getNickname();
        fields.password = p.getPassword();
        fields.gamesWon = p.getGamesWon();
        fields.gamesPlayed = p.getGamesPlayed();
                
        Session session = HibernateSessionUtil.getSession();
        session.clear();//to clear old query if it has cached result set for optimization

        // search Certlett objects
        String hql = "from Player p ";
        if (fields.hasOneField()) {
            hql += "where ";
            hql += fields.getWherePlayer();
            
            System.out.println("Query text: " + hql);
        }
        Query q = session.createQuery(hql);
        fields.setQueryParamsPlayer(q);

        return q;
    }
}
