/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.persistence.dao;

import com.ohell.persistence.util.HibernateSessionUtil;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

/**
 * Base PersistenceManager that supports save(edit) and delete operations for any kind of mapped objects (thanks to Hibernate generics support)
 * @author vasko
 */
public class PersistenceManagerBase {

    /**
     * Saves persistent object in the database
     * @param <T> - the class of the persistent object
     * @param object - the object that is to be persisted
     * @return - the persisted object assosiated with the open HibernateSession
     */
    public static <T> T saveObject(T object){
        Session session = HibernateSessionUtil.getSession();
        HibernateSessionUtil.clearSession();



        boolean bUseExternalTransaction = session.getTransaction().isActive();
        if (!bUseExternalTransaction) {
            session.getTransaction().begin();
        }

        T o = null;
        try {
            o = (T)session.merge(object);

            if (!bUseExternalTransaction) {
                session.getTransaction().commit();
            }

            session.flush();

        } catch (RuntimeException e) {
            e.printStackTrace();
            if (!bUseExternalTransaction) {
                session.getTransaction().rollback();
            }
            throw e;
        }
        return o;
    }

    /**
     * Deletes an object from the Database
     * @param object - the object that is to be removed
     */
    public static void deleteObject(Object object) {                
        Session session = HibernateSessionUtil.getSession();
        HibernateSessionUtil.clearSession();
        
        boolean bUseExternalTransaction = session.getTransaction().isActive();
        if (!bUseExternalTransaction) {
            session.getTransaction().begin();
        }
        session.delete(object);
        if (!bUseExternalTransaction) {
            session.getTransaction().commit();
        }
        session.flush();        
    }

    /**
     * This is the DataBase Fasade's backdoor method for executing custom hql queries that
     * are more specific and complex then the given Facade interface - findByExample
     * @param hqlQuery
     * @return
     */
    public static List executeCustomQuery(String hqlQuery){
        Session session = HibernateSessionUtil.getSession();
        HibernateSessionUtil.clearSession();

        Query q = session.createQuery(hqlQuery);
        return q.list();
    }
}
