/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ohell.persistence.insert;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Statement;
import com.ohell.data.Announce;
import com.ohell.data.Card;

import com.ohell.data.enums.CardColor;
import com.ohell.data.enums.CardStrength;
import com.ohell.persistence.dao.PersistenceManagerBase;
import java.sql.DriverManager;
import java.sql.SQLException;

/**
 *
 * @author vasko
 */
public class InsertStatements {

    private static final int OHELL_MAX_ANNOUNCE = 13;

    public static void main(String[] args) {
        insertAllCardsInDB();
        insertOhellAnnounces();
    }

    private static void insertAllCardsInDB() {

        CardColor color = null;
        CardStrength strength = null;
        for (int i = 0; i < 4; i++) {
            for (int j = 0; j < 13; j++) {
                color = getCardColorByDefaultIndex(i);
                strength = getCardStrengthByDefaultIndex(j);
               
                Card c = new Card(color, strength);
                PersistenceManagerBase.saveObject(c);
            }
        }
    }

    private static void insertOhellAnnounces(){
        for (int i = 0; i <= OHELL_MAX_ANNOUNCE; i++) {
            Announce a = new Announce(i, ""+i);
            a.setGameType("Ohell");
            PersistenceManagerBase.saveObject(a);
        }
    }

    public static Connection getConnection(){
        Connection con = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
        //Class.forName("myDriver.ClassName"); ?

        } catch (java.lang.ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
        }

        try {
           con = (Connection) DriverManager.getConnection("jdbc:mysql://localhost:3306/ohell_schema","root", "root");

        } catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }

        return con;
    }

    public static void insertCard(String insertString) {
        Connection con = getConnection();

        String insertString1;
//        insertString1 = "insert into Employees values(6323, 'Hemanth')";

        try {
            Statement stmt = (Statement) con.createStatement();
            stmt.executeUpdate(insertString);
            stmt.close();
            con.close();

        } catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }        
    }

    private static CardColor getCardColorByDefaultIndex(int index) {
        switch (index) {
            case 0:
                return CardColor.CLUBS;
            case 1:
                return CardColor.DIAMONDS;
            case 2:
                return CardColor.HEARTS;
            case 3:
                return CardColor.SPADES;
            default:
                System.out.println("Error while obtaining CardColor - index = " + index);
                return null;
        }
    }

    private static CardStrength getCardStrengthByDefaultIndex(int index) {
        switch (index) {
            case 0:
                return CardStrength.TWO;
            case 1:
                return CardStrength.THREE;
            case 2:
                return CardStrength.FOUR;
            case 3:
                return CardStrength.FIVE;
            case 4:
                return CardStrength.SIX;
            case 5:
                return CardStrength.SEVEN;
            case 6:
                return CardStrength.EIGHT;
            case 7:
                return CardStrength.NINE;
            case 8:
                return CardStrength.TEN;
            case 9:
                return CardStrength.JACK;
            case 10:
                return CardStrength.QUEEN;
            case 11:
                return CardStrength.KING;
            case 12:
                return CardStrength.ACE;
            default:
                System.out.println("Error while obtaining CardStrength - index = " + index);
                return null;
        }
    }
}
