/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.ohell.persistence.util;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;

/**
 * A Thread-safe implementation for management of the Hibernate's session object
 * @author vasko
 */
public class HibernateSessionUtil {

    private static final ThreadLocal<Session> session = new ThreadLocal<Session>();

    private static final SessionFactory sessionFactory;

    static {
        try {
            sessionFactory = new AnnotationConfiguration().configure().buildSessionFactory();
        } catch (Throwable ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static Session getSession()
            throws HibernateException {

        try {
            Session s = session.get();
            // Open a new Session, if this Thread has none yet
            if (s == null) {
                s = sessionFactory.openSession();
                session.set(s);
            }
            return s;
        } catch (HibernateException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not get a session");
        }

    }


    /**
     * Closes, disconnects and removes the session from the current thread.
     *
     * @throws org.hibernate.HibernateException
     *
     */
    public static void closeSession() throws HibernateException {
        System.out.println("HibernateSessionUtil: closing session");
        Session s = (Session) session.get();

        session.set(null);
        session.remove();
        if (s != null) {
            s.disconnect();
            s.close();
        }
    }


    /**
     * Evokes all the data from the current session and refreshes the currently logged user from database.
     * This method is useful in situations when we need to clear session's cache and then change
     * certain properties of the user - prevents lazy-loading exceptions for the collection
     * properties of an  object.
     */
    public static synchronized void clearSession() {
        System.out.println("HibernateSessionUtil: clearing session");
        getSession().clear();
    }

    public static void main(String args[]) {
        System.out.println("HibernateSessionUtil: test with main method begin.");

        HibernateSessionUtil.getSession();

        HibernateSessionUtil.closeSession();

        System.out.println("HibernateSessionUtil: test with main method end.");
    }

}

