package eu.youssefsan.dom.countWords;

import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import java.util.*;

import eu.youssefsan.dom.countWords.DOMDocument ;
import eu.youssefsan.dom.countWords.CountWords ;

public class SaveResultsInText  {
 private static final String nlMonodix = "apertium-fr-nl.nl.dix.xml";
 private static final String afMonodix = "apertium-en-af.af.dix.xml";
 private static final String nounFile = "myNoun.txt" ;
 private static final String nounParadigmFile = "myNounParadigm.txt";
 
 
 BufferedReader inFile = null;
 PrintWriter outFile = null ;
 PrintWriter paradigmOutFile = null ;

 
 public void saveNounMonodix(String sourceMonodix) {
  CountWords cw = new CountWords();
  DOMDocument dd = new DOMDocument();
  Document myDocument = dd.createDOMDocument(sourceMonodix);
  System.out.println("Creating document with: " +sourceMonodix + ".");
  ArrayList<String> nounArray = cw.getAllNounParadigms(myDocument);
  int i = 1;
  try {
   outFile = new PrintWriter(new FileWriter(nounFile));
   for (String element : nounArray) {
    outFile.println(element);
    //System.out.println("Element " + i +": "+ element );
    i++;
   } 
  }catch (Exception e) {
   System.out.println(e.getMessage()); 
   e.printStackTrace();
  }finally {
    if (outFile != null) {
    outFile.close();
   }
  }
 }
 public void saveNounParadigms(String sourceMonodix) {
  CountWords cw = new CountWords();
  DOMDocument dd = new DOMDocument();
  Document myDocument = dd.createDOMDocument(sourceMonodix);
  //System.out.println("Creating document with: " + sourceMonodix + ".");
  ArrayList<String> nounParadigmArray = cw.getAllNounForms(myDocument);
  int i = 1;
  try {
   outFile = new PrintWriter(new FileWriter(nounParadigmFile));
   for (String element : nounParadigmArray) {
    outFile.println(element);
    //System.out.println("Element " + i +": "+ element );
    i++;
   } 
  }catch (Exception e) {
   System.out.println(e.getMessage()); 
   e.printStackTrace();
  }finally {
    if (outFile != null) {
    outFile.close();
   }
  }
 }
 public static void main (String [] args) {
  SaveResultsInText sv = new SaveResultsInText ();
  //sv.saveNounMonodix(nlMonodix);
  sv.saveNounParadigms(nlMonodix);
    
 }
}

