package com.akujin.onemanga;

import java.util.Iterator;
import java.util.Map;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.AdapterView.OnItemClickListener;

public class chapterList extends Activity {
	
	boolean status = false;
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        //requestWindowFeature(Window.FEATURE_CUSTOM_TITLE);
        //getWindow().setTitle("List of Chapters");
        
        try {
	        Map chapters = OMservice.chaptersList;
	        String[] list = new String[chapters.size()];
	        
	        Iterator it = chapters.keySet().iterator();
	        int count = 0;
	        while (it.hasNext()) {
	            list[count] = it.next().toString();
	            count++;
	        }
	        
	        setContentView(R.layout.animelist_layout);
	        setupChapterListView(list);
        }
    	catch(Exception e) {
    		Log.e("Error:", e.toString(), e);
    	}
    }
    
    private void setupChapterListView(String[] list) {
    	try {
	    	ArrayAdapter listItemAdapter = new ArrayAdapter(this, android.R.layout.simple_list_item_1, list);
	    	ListView lv = (ListView)this.findViewById(R.id.list_view_id);
	    	lv.setAdapter(listItemAdapter);

	    	lv.setOnItemClickListener(new OnItemClickListener(){
	    		public void onItemClick( AdapterView av, View v, int index, long arg){
	    			//Map chapters = OMservice.getAnimeList();
	    			//OMservice.setCurrentManga(av.getItemAtPosition(index).toString());
	    			
	    			
	    			OMservice.currentChapter = OMservice.chaptersList.get(av.getItemAtPosition(index).toString()).toString();
	    			
	    			boolean status = false;
	    			
	    			int i = 0;
	    			while(!status && i<10) {
		    			status = OMservice.refreshPageList();
		    			i++;
	    			}
	    			
	    			if(status) {
	    				Intent myIntent = new Intent(v.getContext(), pageView.class);
	    		        startActivity(myIntent);
	    			}
	    		}
	    	
	    	});
    	}
    	catch(Exception e) {
    		Log.e("Error:", e.toString(), e);
    	}
    } 
    
}
