package kontrol;

import model.interfaces.commandTypes.ArgumentsVisitor;
import model.interfaces.commandTypes.ArmyArgs;
import model.interfaces.commandTypes.DirectionArgs;
import model.interfaces.commandTypes.MoveArgs;
import model.interfaces.commandTypes.NoArgs;
import view.ViewViewPort;
import model.Direction;

/**
 *
 * @author kagioglu
 */
public class ArgVisitor implements ArgumentsVisitor
{
    private Integer[] args;
    private ViewViewPort viewport;
    private static Direction[] map;

    {
        ArgVisitor.map = new Direction[]
        {
            null,
            Direction.SW,
            Direction.S,
            Direction.SE,
            Direction.W,
            Direction.C,
            Direction.E,
            Direction.NW,
            Direction.N,
            Direction.NE
        };
    }

    private static Direction convert(int code)
    {
        if(0 < code && 10 > code)
        {
            return ArgVisitor.map[code];
        }
        else
        {
            throw new RuntimeException("int code fail");
        }
    }

    public ArgVisitor( Integer[] args, ViewViewPort viewport )
    {
        this.args = args;
        this.viewport = viewport;
    }

    public void visitArmyArgs( ArmyArgs command )
    {
        command.setArgs(args[args.length - 1]);
    }

    public void visitDirectionArgs( DirectionArgs command )
    {
        command.setArgs(ArgVisitor.convert(args[args.length - 1]));
    }

    public void visitMoveArgs( MoveArgs command )
    {
        if(ArgVisitor.convert(args[args.length - 1]) == Direction.C)
        {
            Direction[] dirargs = new Direction[args.length - 1];
            for(int i = 0; i < dirargs.length; i++)
            {
                dirargs[i] = ArgVisitor.convert(args[i]);
            }
            command.setArgs(dirargs);
        }
    }

    public void visitNoArgs( NoArgs command )
    {
        //do nothing
    }
}
