package kontrol;

import view.Vew;
import view.ViewHUD;
import view.ViewOverview;
import view.ViewViewPort;
import model.TileTranslator;
import java.awt.event.KeyListener;
import model.interfaces.selectable.InstanceTypeAndHealth;
import java.awt.Point;

/**
 *
 * @author kagioglu
 */
public class FakeView implements
    Vew,
    ViewHUD,
    ViewOverview,
    ViewViewPort
{
    private static void print( String string )
    {
        System.out.println(FakeView.class.getName() + "::" + string);
    }

    public static void createAndShowGUI()
    {
        print("createAndShowGUI");
    }

    public void setSelectedPath(Point[] points)
    {
        print("setSelectedPath");
        for(Point p : points)
        {
            print("    " + p.x + "," + p.y);
        }
    }

    public void center(Point point)
    {
        print("center");
        print("    " + point.x + "," + point.y);
    }

    public void openOverview( String name, String[] list, String[] legend )
    {
        print("openOverview");
        print("    " + name);
        for(String s : list)
        {
            print("    " + s);
        }
        for(String s : legend)
        {
            print("    " + s);
        }
    }

    public void setOverview( String[] strings )
    {
        print("setOverview");
        for(String s : strings)
        {
            print("    " + s);
        }
    }

    public void closeOverview()
    {
        print("closeOverview");
    }

    public void setSelectionIndex( int index )
    {
        print("setSelectionIndex");
        print("    " + index);
    }

    public void openCommandQueue( String[] strings )
    {
        print("openCommandQueue");
        for(String s : strings)
        {
            print("    " + s);
        }
    }

    public void setCommandQueue( String[] strings )
    {
        print("setCommandQueue");
        for(String s : strings)
        {
            print("    " + s);
        }
    }

    public void closeCommandQueue()
    {
        print("closeCommandQueue");
    }

    public void setGroupBox( String name )
    {
        print("setGroupBox");
        print("    " + name);
    }

    public void setTypeBox( String name )
    {
        print("setTypeBox");
        print("    " + name);
    }

    public void setInstanceBox( String name )
    {
        print("setInstanceBox");
        print("    " + name);
    }

    public void setCommandBox( String name )
    {
        print("setCommandBox");
        print("    " + name);
    }

    public void setStatusOverview( InstanceTypeAndHealth[] itahs )
    {
        print("setStatusOverview");
        for(InstanceTypeAndHealth i : itahs)
        {
            print("    " + i.getType());
            print("    " + i.getPercentHealth());
        }
    }

    public void addKeyListener( KeyListener listener )
    {
        print("addKeyListener");
        print("    " + listener);
    }

    public void removeKeyListener( KeyListener listener )
    {
        print("removeKeyListener");
        print("    " + listener);
    }

    public void register(TileTranslator translator, KeyListener listener)
    {
        print("register");
        print("    " + translator);
        print("    " + listener);
    }
}
