package kontrol;

import model.interfaces.selectable.ControllableModel;

/**
 *
 * @author kagioglu
 */
public class GameManager
{
    private final ControllableModel cmodel;
    private boolean isGameRunning;

    public GameManager( ControllableModel cmodel )
    {
        this.cmodel = cmodel;
        this.isGameRunning = false;
    }

    public void startGame()
    {
        if(!this.isGameRunning)
        {
            this.cmodel.startGame();
            this.isGameRunning = true;
        }
    }

    public void endGame()
    {
        if(this.isGameRunning)
        {
            this.cmodel.endGame();
            this.isGameRunning = false;
        }
    }
}
