package kontrol;

import model.interfaces.selectable.ControllablePlayer;
import model.interfaces.selectable.SelectableRallyPoint;
import model.interfaces.selectable.SelectableCommand;

/**
 *
 * @author kagioglu
 */
public class UnitOverviewConverter implements HasList
{
    class HasQueueUnitOverview implements HasQueue
    {
        private SelectableRallyPoint rallypoint;
        public HasQueueUnitOverview( SelectableRallyPoint rallypoint )
        {
            this.rallypoint = rallypoint;
        }
        public String getName()
        {
            return "Rallypoint: " + this.rallypoint.getID();
        }
        public String[] getQueue()
        {
            SelectableCommand[] commands = this.rallypoint.getQueue();
            String[] result = new String[commands.length];
            for(int i = 0; i < commands.length; i++)
            {
                result[i] = commands[i].getName();
            }
            return result;
        }
    }

    private ControllablePlayer cplayer;

    public UnitOverviewConverter( ControllablePlayer cplayer )
    {
        this.cplayer = cplayer;
    }

    public HasQueue[] getHasQueues()
    {
        SelectableRallyPoint[] rallypoints = this.cplayer.getRallyPoints();
        HasQueue[] result = new HasQueue[rallypoints.length];
        for(int i = 0; i < rallypoints.length; i++)
        {
            result[i] = new HasQueueUnitOverview(rallypoints[i]);
        }
        return result;
    }
}
