package model;

import _bye_util.IntRecycler;

/**
 * represents a Base. Has the default constructor.
 * 
 * @author Chris
 * 
 */
class Base extends Structure
{
    
    public Base( IntRecycler i ) {
        super( i, InstanceType.BASE,// type
               "Base",// name
               0, // bricks
               10, // max_bricks
               100, // health
               100, // max_health
               1000, // armor
               10, // attack_power
               10, // defense_power
               0, // upkeepRed
               0, // upkeepGreen
               2 // upkeepBlue
        );
        healing_rate = 10;
        production_rate = 10;
        
        // initialize base-specific available commands
        super.addAvailCommand( new TrainMelee() );
        super.addAvailCommand( new TrainRanged() );
        super.addAvailCommand( new TrainColonist() );
        super.addAvailCommand( new TrainExplorer() );
        super.addAvailCommand( new Heal() );
    }
    
    private int healing_rate; // this is in the units of health per tick.
    private int production_rate;
    
    /**
     * 
     * @return the healing rate in hp per tick for each unit on same tile.
     */
    public int getHeal()
    {
        return healing_rate;
    }
    
    public int getProduction_rate()
    {
        return production_rate;
    }
    
}
