package model;

import model.interfaces.selectable.SelectableCommand;
import model.interfaces.commandTypes.ArgumentsVisitor;
import model.interfaces.commandTypes.NoArgs;

/**
 * Command to build a new base.
 * 
 * @author Alex Kagioglu
 * @author Christopher Dudley
 */
class BuildBase implements Command, SelectableCommand, NoArgs, NotPartOfTheSystem
{
    private static final String name = "Build Base";
    
    /**
     * Accepts an ArgumentsVisitor so that the argument type of the command can
     * be determined and the command executed properly.
     * 
     * @param visitor
     *            the ArgumentsVisitor
     */
    public void accept( ArgumentsVisitor visitor )
    {
        visitor.visitNoArgs( this );
    }
    
    /**
     * Returns a new Command version of this command.
     * 
     * @return a Command-type of this command.
     */
    public Command getCommand()
    {
        return this;
    }
    
    /**
     * Returns the name of the command.
     * 
     * @return the name of the command.
     */
    public String getName()
    {
        return name;
    }
    
    /**
     * Executes the command.
     * 
     * @param player
     *            the player that owns the unit building the base.
     * @param instance
     *            the unit that is building the base.
     */
    public void run( Player player, ModelInstance instance )
    {
        player.buildBase( instance );
    }
    
    /**
     * It's not part of your system
     */
    public void throwItOnTheGround()
    {
        new ThrowItOnTheGround().cuzMyDadIsNotA( this );
    }
}
