package model;

import model.interfaces.selectable.SelectableCommand;
import model.interfaces.commandTypes.ArgumentsVisitor;
import model.interfaces.commandTypes.NoArgs;

/**
 * Creates a new Tower structure.
 * 
 * @author Alex Kagioglu
 * @author Christopher Dudley
 */
class BuildTower implements Command, SelectableCommand, NoArgs, NotPartOfTheSystem
{
    private static final String name = "Build Tower";
    
    public void accept( ArgumentsVisitor visitor )
    {
        visitor.visitNoArgs( this );
    }
    
    /**
     * Returns a new Command-type version of this command.
     * 
     * @return a Command version of this command.
     */
    public Command getCommand()
    {
        return this;
    }
    
    /**
     * Returns the name of the command.
     * 
     * @return the name of the command.
     */
    public String getName()
    {
        return name;
    }
    
    /**
     * Executes the command.
     * 
     * @param player
     *            the player who owns the unit building the tower.
     * @param instance
     *            the unit building the tower.s
     */
    public void run( Player player, ModelInstance instance )
    {
        player.buildTower( instance );
    }
    
    /**
     * It's not part of your system, man!
     */
    public void throwItOnTheGround()
    {
        new ThrowItOnTheGround().cuzMyDadIsNotA( this );
    }
}
