package model;

import java.util.Timer;

/**
 * 
 * @author kagioglu
 */
public class ClockTester implements ClockListener
{
    public static void main( String[] args )
    {
        ClockTester.test1();
        ClockTester.test2();
    }
    
    private static void test1()
    {
        Timer timer = new Timer();
        timer.cancel();
    }
    
    private static void test2()
    {
        Clock clock = new StrawberryClock( 1000 );
        clock.addListener( new ClockTester() );
        
        clock.start();
        try
        {
            Thread.sleep( 8500 );
        }
        catch ( InterruptedException e )
        {
            throw new RuntimeException( e );
        }
        finally
        {
            clock.stop();
        }
    }
    
    public void tick()
    {
        System.out.println( "tick!" );
    }
}
