package model;

import model.interfaces.selectable.SelectableCommand;
import model.interfaces.commandTypes.ArgumentsVisitor;
import model.interfaces.commandTypes.NoArgs;

class Decommission implements Command, SelectableCommand, NoArgs, NotPartOfTheSystem
{
    private static final String name = "Decommission";
    
    public void throwItOnTheGround()
    {
        new ThrowItOnTheGround().cuzMyDadIsNotA( this );
    }
    
    public void run( Player player, ModelInstance instance )
    {
        player.decommission( instance );
    }
    
    public void accept( ArgumentsVisitor visitor )
    {
        visitor.visitNoArgs( this );
    }
    
    public String getName()
    {
        return name;
    }
    
    public Command getCommand()
    {
        return this;
    }
}
