package model;

import model.interfaces.selectable.SelectableCommand;
import model.interfaces.commandTypes.ArgumentsVisitor;
import model.interfaces.commandTypes.NoArgs;

class DisbandArmy implements Command, SelectableCommand, NoArgs, NotPartOfTheSystem
{
    
    private static final String name = "Disband";
    
    public void throwItOnTheGround()
    {
        new ThrowItOnTheGround().cuzMyDadIsNotA( this );
    }
    
    public void run( Player player, ModelInstance instance )
    {
        player.disband( instance );
    }
    
    public void accept( ArgumentsVisitor visitor )
    {
        visitor.visitNoArgs( this );
    }
    
    public String getName()
    {
        return name;
    }
    
    public Command getCommand()
    {
        return this;
    }
}
