package model;

import _bye_util.IntRecycler;

import model.interfaces.selectable.SelectableCommand;

import java.util.List;
import java.util.ArrayList;

/**
 * 
 * @author Chris
 * 
 */
class Explorer extends Unit
{
    Explorer( IntRecycler i ) {
        super( i, // int recycler
               InstanceType.EXPLORER, // instance type
               20, // armor
               5, // attack power
               10, // defense power
               1, // speed
               "Explorer", // name
               0, // upkeep red
               5, // upkeep green
               0 // upkeep blue
        );
    }
    
    /**
     * Explorers are jerks and don't have any additional commands for a rally
     * point.
     * 
     * @return the additional commands this unit brings to a rally point (null).
     */
    public List< SelectableCommand > getAdditionalCommands()
    {
        return new ArrayList< SelectableCommand >();
    }
    
    /**
     * deviation from uml
     * 
     * @author alex kagioglu
     */
    public Location[] getExploredArray( Location location )
    {
        final int diameter = 3;
        Location[] locarray = new Location[ diameter * diameter ];
        for ( int i = 0; i < diameter; i++ )
        {
            for ( int j = 0; j < diameter; j++ )
            {
                locarray[ i * diameter + j ] = new Location( location.x + i - diameter / 2,
                        location.y + j - diameter / 2 );
            }
        }
        return locarray;
    }
}
