package model;

import java.io.Serializable;

class GameMap implements Serializable
{
    /**
	 * 
	 */
    private static final long serialVersionUID = -7594135050346401965L;
    private Tile[][] tiles;
    private int width, height;
    private Location startingLocation1;
    private Location startingLocation2;
    
    public GameMap() {
        width = height = 0;
        startingLocation1 = startingLocation2 = null;
        tiles = null;
    }
    
    public GameMap( int x, int y ) {
        width = x;
        height = y;
        tiles = new Tile[ x ][ y ];
        startingLocation1 = new Location( 0, 0 );
        startingLocation2 = new Location( x - 1, y - 1 );
    }
    
    public Tile getTile( int x, int y )
    {
        return tiles[ x ][ y ];
    }
    
    public void setTile( int x, int y, Tile tile )
    {
        tiles[ x ][ y ] = tile;
    }
    
    public int getWidth()
    {
        return width;
    }
    
    public int getHeight()
    {
        return height;
    }
    
    // DEVIATION: Need to set where a player can start
    public void setStartingLocation1( Location l )
    {
        startingLocation1 = l;
    }
    
    // DEVIATION: Need to set where a player can start
    public void setStartingLocation2( Location l )
    {
        startingLocation2 = l;
    }
    
    // DEVIATION: Need to know where a player can start
    public Location getStartingLocation1()
    {
        return startingLocation1;
    }
    
    // DEVIATION: Need to know where a player can start
    public Location getStartingLocation2()
    {
        return startingLocation2;
    }
    
}
