package model;

import java.util.List;
import java.util.ArrayList;

import model.interfaces.selectable.SelectableGroup;
import model.interfaces.selectable.SelectableType;

/**
 * Represents a selectable group of types of game instances.
 * 
 * @author kagioglu
 * @author Christopher Dudley
 */
public class Group implements SelectableGroup
{
    private String name;
    private List< SelectableType > typelist;
    
    /**
     * Creates a new Group with a set name and an empty list of SelectableTypes.
     * 
     * @author Christopher Dudley
     * 
     * @param name
     *            the name of the group.
     */
    public Group( String name ) {
        this.typelist = new ArrayList< SelectableType >();
        this.name = name;
    }
    
    /**
     * Returns the group's name.
     * 
     * @author Alex Kagioglu
     * 
     * @return the group's name.
     */
    public String getName()
    {
        return this.name;
    }
    
    // Deviation: Removed setName()
    // Not required with the name set in the constructor.
    
    /**
     * Returns an array of the different selectable types in this group.
     * 
     * @author Alex Kagioglu
     * 
     * @return the selectable types in this group.
     */
    public SelectableType[] getTypes()
    {
        return this.typelist.toArray( new SelectableType[ this.typelist.size() ] );
    }
    
    /**
     * Adds a new selectable type to the list of selectable types in this group.
     * 
     * @author Alex Kagioglu
     * 
     * @param type
     *            the selectable type to add.
     */
    public void addType( SelectableType type )
    {
        this.typelist.add( type );
    }
}
