package model;

import java.io.Serializable;

/**
 * Stores an item of some type.
 * 
 * @author Adam
 * 
 */
abstract class Item implements Serializable
{
    private ItemType type;
    
    public Item( ItemType type ) {
        this.type = type;
    }
    
    private static final long serialVersionUID = 3605410571793473460L;
    
    public abstract void accept( Player p, ItemVisitor visitor, ModelInstance mi );
    
    public ItemType getType()
    {
        return type;
    }
    
    public abstract boolean isObstacle();
}
