package model;

import model.interfaces.selectable.SelectableCommand;
import model.interfaces.commandTypes.ArgumentsVisitor;
import model.interfaces.commandTypes.NoArgs;

/**
 * Command to cause the unit to leave its current army and return to standby
 * mode.
 * 
 * @author Christopher Dudley
 */
class LeaveArmy implements Command, SelectableCommand, NoArgs, NotPartOfTheSystem
{
    
    private static final String name = "Leave Army";
    
    /**
     * Accepts an ArgumentsVisitor in order to determine the arguments type of
     * the commands and correctly initialize and queue the command.
     * 
     * @param visitor
     *            the ArgumentsVisitor.
     */
    public void accept( ArgumentsVisitor visitor )
    {
        visitor.visitNoArgs( this );
    }
    
    /**
     * Returns a copy of the command with a Command-type reference.
     * 
     * @return a Command version of the command.
     */
    public Command getCommand()
    {
        return this;
    }
    
    /**
     * Returns the name of the command.
     * 
     * @return the name of the command.
     */
    public String getName()
    {
        return name;
    }
    
    /**
     * Executes the command.
     * 
     * @param player
     *            the player that owns the unit.
     * @param instance
     *            the instance of the unit leaving its army.
     */
    public void run( Player player, ModelInstance instance )
    {
        player.leaveArmy( instance );
    }
    
    /**
     * It's not part of your system, man!
     */
    public void throwItOnTheGround()
    {
        new ThrowItOnTheGround().cuzMyDadIsNotA( this );
    }
}
