package model;

import _bye_util.IntRecycler;

import model.interfaces.selectable.SelectableCommand;

import java.util.List;
import java.util.ArrayList;

/**
 * 
 * @author Chris
 * 
 */
class Melee extends Unit
{
    public Melee( IntRecycler i ) {
        super( i, // int recycler
               InstanceType.MELEE, // instance type
               20, // armor
               10, // attack power
               10, // defense power
               3, // speed
               "Melee", // name
               3, // upkeep red
               4, // upkeep green
               5 // upkeep blue
        );
    }
    
    /**
     * Melee units are jerks and don't have any additional commands for a rally
     * point.
     * 
     * @return the additional commands this unit brings to a rally point (null).
     */
    public List< SelectableCommand > getAdditionalCommands()
    {
        return new ArrayList< SelectableCommand >();
    }
}
