package model;

class OneShotAddResource extends OneShot
{
    /**
	 * 
	 */
    private static final long serialVersionUID = 716723820090166993L;
    private int quantity;
    private ResourceType type;
    
    public OneShotAddResource( ItemType type, ResourceType rType, int amount ) {
        super( type );
        this.type = rType;
        quantity = amount;
    }
    
    public ResourceType getResourceType()
    {
        return type;
    }
    
    public int getQuantity()
    {
        return quantity;
    }
    
    public void accept( Player p, ItemVisitor visitor, ModelInstance mi )
    {
        visitor.visitAddResource( p, this );
    }
    
}
