package model;

import java.util.EnumMap;
import java.util.List;

/**
 * Creates a tile suitable to be viewed by the view.
 * 
 * @author Adam
 * 
 */
class ScienceTile implements MagicTile
{
    private EnumMap< InstanceType, Integer > unitsOnTile;
    private Structure structureOnTile = null;
    private Alliance allegiance = Alliance.NEUTRAL;
    private DecalType decal = DecalType.UNEXPLORED;
    private ResourceType resourceType = ResourceType.NONE;
    private int numResources = 0;
    private TerrainType terrain = TerrainType.UNKNOWN;
    private int[] rallypoints = null;
    private ItemType item = ItemType.NOTHING;
    
    /**
     * Constructor: Builds the ScienceTile using data passed in from Model
     * 
     * @param p1
     *            the first (assumedly human) player
     * @param p2
     *            the second (assumedly AI) player
     * @param t
     *            the Tile to translate
     * @param l
     *            the location of the tile
     */
    public ScienceTile( Player p1, Player p2, Tile t, Location l ) {
        // Debug: System.out.println(l);
        if ( p1 != null && p2 != null )
        {
            // debug: System.out.println("THERE ARE PLAYER THINGS HERE");
            // get list of units on t, determine if they're friendly
            List< Unit > u1 = p1.getUnitsAt( l );
            List< Unit > u2 = p2.getUnitsAt( l );
            
            if ( u1 != null && u1.size() != 0 )
            {
                
                // debug: System.out.println("P1 has units");
                setUnits( u1 );
                allegiance = Alliance.FRIENDLY;
            }
            else if ( u2 != null && u2.size() != 0 )
            {
                // debug: System.out.println("P2 has units");
                setUnits( u2 );
                allegiance = Alliance.HOSTILE;
            }
            else
            {
                // debug: System.out.println("p1's unit list here is empty: " +
                // (u1 == null));
                unitsOnTile = new EnumMap< InstanceType, Integer >( InstanceType.class );
            }
            
            // get the structure on t, if any; determine if it's friendly
            Structure s1 = p1.getStructureAt( l );
            Structure s2 = p2.getStructureAt( l );
            
            if ( s1 != null )
            {
                structureOnTile = s1;
                allegiance = Alliance.FRIENDLY;
            }
            else if ( s2 != null )
            {
                structureOnTile = s2;
                allegiance = Alliance.HOSTILE;
            }
            else
                structureOnTile = null;
            
            // get the decal of t's location from p
            decal = p1.getDecalAt( l );
            
            // get rally points at l, if any
            int[] rp1 = p1.getRallyPointIDsAt( l );
            int[] rp2 = p2.getRallyPointIDsAt( l );
            
            if ( rp1.length != 0 )
            {
                rallypoints = rp1;
            }
            else if ( rp2.length != 0 )
            {
                rallypoints = rp2;
            }
            else
                rallypoints = null;
            
        }
        /*
         * else System.out.println("THERE IS NOTHING HERE");
         */
        // get what resources, if any, are on t, and how much there is
        if ( decal != DecalType.UNEXPLORED )
        {
            // get terrain type of t
            terrain = t.getTerrainType();
            
            if ( decal != DecalType.EXPLORED_BASIC )
            {
                resourceType = t.getResource();
                numResources = t.getResourceCount();
                
                // get itemType of t, if it has one
                if ( t.getItem() == null )
                    item = ItemType.NOTHING;
                else
                    item = t.getItem().getType();
            }
        }
    }
    
    public EnumMap< InstanceType, Integer > getUnits()
    {
        return unitsOnTile;
    }
    
    public InstanceType getStructure()
    {
        if ( structureOnTile != null ) return structureOnTile.getInstanceType();
        return InstanceType.NULL;
    }
    
    public int[] getRallyPoints()
    {
        return rallypoints;
    }
    
    public TerrainType getTerrain()
    {
        return terrain;
    }
    
    public DecalType getDecal()
    {
        return decal;
    }
    
    public ResourceType getResourceType()
    {
        return resourceType;
    }
    
    public int getResourceCount( ResourceType rt )
    {
        if ( rt == resourceType ) return numResources;
        return 0;
    }
    
    public Alliance getAllianceEnum()
    {
        return allegiance;
    }
    
    public ItemType getItemType()
    {
        return item;
    }
    
    /**
     * Sets the units on the tile into a format viewable by View.
     * 
     * @param units
     */
    private void setUnits( List< Unit > units )
    {
        unitsOnTile = new EnumMap< InstanceType, Integer >( InstanceType.class );
        for ( int i = 0; i < units.size(); i++ )
        {
            if ( unitsOnTile.containsKey( (units.get( i )).getInstanceType() ) )
            {
                Integer n = unitsOnTile.get( units.get( i ).getInstanceType() );
                n = new Integer( n.intValue() + 1 );
                unitsOnTile.put( units.get( i ).getInstanceType(), n );
            }
            else
            {
                unitsOnTile.put( units.get( i ).getInstanceType(), new Integer( 1 ) );
            }
        }
    }
}
