package model;

import model.interfaces.selectable.SelectableCommand;
import model.interfaces.commandTypes.ArgumentsVisitor;

class Wait implements Command, SelectableCommand, NotPartOfTheSystem
{
    private static final String name = "Wait";
    
    public void throwItOnTheGround()
    {
        new ThrowItOnTheGround().cuzMyDadIsNotA( this );
    }
    
    public void run( Player player, ModelInstance instance )
    {
        instance.popCommand();
    }
    
    public void accept( ArgumentsVisitor visitor )
    {
        // do nothing
    }
    
    public String getName()
    {
        return name;
    }
    
    public Command getCommand()
    {
        return this;
    }
}
