/*
 * File: ArgumentsVisitor.java
 */

package model.interfaces.commandTypes;

/**
 * Used to differentiate between command argument types and handle input of
 * arguments.
 * 
 * @author Christopher Dudley
 */
public interface ArgumentsVisitor
{
    
    /**
     * Handles input of the army ID arguments for the ArmyArgs-type command, as
     * well as queueing of the command.
     * 
     * @param command
     *            the command that requires an Army ID argument.
     */
    public void visitArmyArgs( ArmyArgs command );
    
    /**
     * Handles input of the single direction argument for the DirectionArgs-type
     * command, as well as queueing of the command.
     * 
     * @param command
     *            the command that requires a single directional argument.
     */
    public void visitDirectionArgs( DirectionArgs command );
    
    /**
     * Handles input of the multiple direction arguments for the MoveArgs-type
     * command, as well as queueing of the command.
     * 
     * @param command
     *            the command that requires multiple directional arguments for
     *            movement.
     */
    public void visitMoveArgs( MoveArgs command );
    
    /**
     * Handles queueing of the command that requies no additional information to
     * execute.
     * 
     * @param command
     *            the command that requires no argument.
     */
    public void visitNoArgs( NoArgs command );
}
