/*
 * File: DirectionArgs.java
 */

package model.interfaces.commandTypes;

import model.Direction;

/**
 * Implemented by commands that require a direction as an argument.
 * 
 * @author Christopher Dudley
 */
public interface DirectionArgs
{
    
    /**
     * Sets the direction required by the command.
     * 
     * @param direction
     *            the direction that is the target of the command.
     */
    public void setArgs( Direction direction );
}
