/*
 * File: ControllableModel.java
 */

package model.interfaces.selectable;

/**
 * Allows the controller to retrieve information about a controllable player as
 * well as start and end the game.
 * 
 * @author Christopher Dudley
 */
public interface ControllableModel
{
    
    /**
     * Ends the game.
     */
    public void endGame();
    
    /**
     * Returns a reference to the human-controlled player object.
     * 
     * @return a reference to the controllable player.
     */
    public ControllablePlayer getPlayer();
    
    /**
     * Starts the game.
     */
    public void startGame();
}
